/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.cloud.opentelemetry.metric;

import java.util.Set;
import java.util.logging.Logger;
import net.snowflake.client.jdbc.internal.google.api.MonitoredResource;
import net.snowflake.client.jdbc.internal.google.cloud.opentelemetry.metric.MonitoredResourceDescription;
import net.snowflake.client.jdbc.internal.google.cloud.opentelemetry.resource.GcpResource;
import net.snowflake.client.jdbc.internal.google.common.base.Strings;
import net.snowflake.client.jdbc.internal.opentelemetry.api.common.AttributeKey;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.resources.Resource;

public class ResourceTranslator {
    private static final String CUSTOM_MR_KEY = "gcp.resource_type";
    private static final Logger LOGGER = Logger.getLogger(ResourceTranslator.class.getCanonicalName());

    private ResourceTranslator() {
    }

    @Deprecated
    public static MonitoredResource mapResource(Resource resource) {
        GcpResource gcpResource = net.snowflake.client.jdbc.internal.google.cloud.opentelemetry.resource.ResourceTranslator.mapResource(resource);
        MonitoredResource.Builder mr = MonitoredResource.newBuilder();
        mr.setType(gcpResource.getResourceType());
        gcpResource.getResourceLabels().getLabels().forEach(mr::putLabels);
        return mr.build();
    }

    static MonitoredResource mapResource(Resource resource, MonitoredResourceDescription mrDescription) {
        String mrTypeToMap = resource.getAttributes().get(AttributeKey.stringKey(CUSTOM_MR_KEY));
        if (Strings.isNullOrEmpty(mrTypeToMap)) {
            return ResourceTranslator.mapResourceUsingCustomerMappings(resource);
        }
        if (!mrTypeToMap.equals(mrDescription.getMonitoredResourceType())) {
            LOGGER.warning(String.format("MonitoredResource type mismatch: Description provided for %s, but found %s in resource attributes. Defaulting to standard mappings.", mrDescription.getMonitoredResourceType(), mrTypeToMap));
            return ResourceTranslator.mapResourceUsingCustomerMappings(resource);
        }
        return ResourceTranslator.mapResourceUsingPlatformMappings(resource, mrTypeToMap, mrDescription);
    }

    private static MonitoredResource mapResourceUsingPlatformMappings(Resource resource, String mrTypeToMap, MonitoredResourceDescription monitoredResourceDescription) {
        Set<String> expectedMRLabels = monitoredResourceDescription.getMonitoredResourceLabels();
        MonitoredResource.Builder mr = MonitoredResource.newBuilder();
        mr.setType(mrTypeToMap);
        expectedMRLabels.forEach(expectedLabel -> {
            String foundValue = resource.getAttribute(AttributeKey.stringKey(expectedLabel));
            if (foundValue != null) {
                mr.putLabels((String)expectedLabel, foundValue);
            }
        });
        return mr.build();
    }

    private static MonitoredResource mapResourceUsingCustomerMappings(Resource resource) {
        GcpResource gcpResource = net.snowflake.client.jdbc.internal.google.cloud.opentelemetry.resource.ResourceTranslator.mapResource(resource);
        MonitoredResource.Builder mr = MonitoredResource.newBuilder();
        mr.setType(gcpResource.getResourceType());
        gcpResource.getResourceLabels().getLabels().forEach(mr::putLabels);
        return mr.build();
    }
}

