/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.fasterxml.jackson.datatype.jsr310.deser;

import java.io.IOException;
import java.time.Month;
import java.util.regex.Pattern;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonParser;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonToken;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.DeserializationContext;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonDeserializer;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.deser.std.DelegatingDeserializer;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.exc.InvalidFormatException;

public class OneBasedMonthDeserializer
extends DelegatingDeserializer {
    private static final long serialVersionUID = 1L;
    private static final Pattern HAS_ONE_OR_TWO_DIGITS = Pattern.compile("^\\d{1,2}$");

    public OneBasedMonthDeserializer(JsonDeserializer<?> defaultDeserializer) {
        super(defaultDeserializer);
    }

    @Override
    public Object deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        JsonToken token = parser.currentToken();
        Month zeroBaseMonth = (Month)this.getDelegatee().deserialize(parser, context);
        if (!this._isNumericValue(parser.getText(), token)) {
            return zeroBaseMonth;
        }
        if (zeroBaseMonth == Month.JANUARY) {
            throw new InvalidFormatException(parser, "Month.JANUARY value not allowed for 1-based Month.", (Object)zeroBaseMonth, Month.class);
        }
        return zeroBaseMonth.minus(1L);
    }

    private boolean _isNumericValue(String text, JsonToken token) {
        return token == JsonToken.VALUE_NUMBER_INT || this._isNumberAsString(text, token);
    }

    private boolean _isNumberAsString(String text, JsonToken token) {
        return token == JsonToken.VALUE_STRING && HAS_ONE_OR_TWO_DIGITS.matcher(text).matches();
    }

    @Override
    protected JsonDeserializer<?> newDelegatingInstance(JsonDeserializer<?> newDelegatee) {
        return new OneBasedMonthDeserializer(newDelegatee);
    }
}

