/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices.stats;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class ShardSequenceNumber
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, ShardSequenceNumber> {
    private final long globalCheckpoint;
    private final long localCheckpoint;
    private final long maxSeqNo;
    public static final JsonpDeserializer<ShardSequenceNumber> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShardSequenceNumber::setupShardSequenceNumberDeserializer);

    private ShardSequenceNumber(Builder builder) {
        this.globalCheckpoint = ApiTypeHelper.requireNonNull(builder.globalCheckpoint, this, "globalCheckpoint");
        this.localCheckpoint = ApiTypeHelper.requireNonNull(builder.localCheckpoint, this, "localCheckpoint");
        this.maxSeqNo = ApiTypeHelper.requireNonNull(builder.maxSeqNo, this, "maxSeqNo");
    }

    public static ShardSequenceNumber of(Function<Builder, ObjectBuilder<ShardSequenceNumber>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long globalCheckpoint() {
        return this.globalCheckpoint;
    }

    public final long localCheckpoint() {
        return this.localCheckpoint;
    }

    public final long maxSeqNo() {
        return this.maxSeqNo;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("global_checkpoint");
        generator.write(this.globalCheckpoint);
        generator.writeKey("local_checkpoint");
        generator.write(this.localCheckpoint);
        generator.writeKey("max_seq_no");
        generator.write(this.maxSeqNo);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupShardSequenceNumberDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::globalCheckpoint, JsonpDeserializer.longDeserializer(), "global_checkpoint");
        op.add(Builder::localCheckpoint, JsonpDeserializer.longDeserializer(), "local_checkpoint");
        op.add(Builder::maxSeqNo, JsonpDeserializer.longDeserializer(), "max_seq_no");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Long.hashCode(this.globalCheckpoint);
        result = 31 * result + Long.hashCode(this.localCheckpoint);
        result = 31 * result + Long.hashCode(this.maxSeqNo);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShardSequenceNumber other = (ShardSequenceNumber)o;
        return this.globalCheckpoint == other.globalCheckpoint && this.localCheckpoint == other.localCheckpoint && this.maxSeqNo == other.maxSeqNo;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, ShardSequenceNumber> {
        private Long globalCheckpoint;
        private Long localCheckpoint;
        private Long maxSeqNo;

        public Builder() {
        }

        private Builder(ShardSequenceNumber o) {
            this.globalCheckpoint = o.globalCheckpoint;
            this.localCheckpoint = o.localCheckpoint;
            this.maxSeqNo = o.maxSeqNo;
        }

        private Builder(Builder o) {
            this.globalCheckpoint = o.globalCheckpoint;
            this.localCheckpoint = o.localCheckpoint;
            this.maxSeqNo = o.maxSeqNo;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder globalCheckpoint(long value) {
            this.globalCheckpoint = value;
            return this;
        }

        @Nonnull
        public final Builder localCheckpoint(long value) {
            this.localCheckpoint = value;
            return this;
        }

        @Nonnull
        public final Builder maxSeqNo(long value) {
            this.maxSeqNo = value;
            return this;
        }

        @Override
        @Nonnull
        public ShardSequenceNumber build() {
            this._checkSingleUse();
            return new ShardSequenceNumber(this);
        }
    }
}

