/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.BundleTask;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BundleInstanceResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, BundleInstanceResponse> {
    private static final SdkField<BundleTask> BUNDLE_TASK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BundleTask").getter(BundleInstanceResponse.getter(BundleInstanceResponse::bundleTask)).setter(BundleInstanceResponse.setter(Builder::bundleTask)).constructor(BundleTask::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BundleInstanceTask").unmarshallLocationName("bundleInstanceTask").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUNDLE_TASK_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BundleInstanceResponse.memberNameToFieldInitializer();
    private final BundleTask bundleTask;

    private BundleInstanceResponse(BuilderImpl builder) {
        super(builder);
        this.bundleTask = builder.bundleTask;
    }

    public final BundleTask bundleTask() {
        return this.bundleTask;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.bundleTask());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BundleInstanceResponse)) {
            return false;
        }
        BundleInstanceResponse other = (BundleInstanceResponse)((Object)obj);
        return Objects.equals(this.bundleTask(), other.bundleTask());
    }

    public final String toString() {
        return ToString.builder((String)"BundleInstanceResponse").add("BundleTask", (Object)this.bundleTask()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BundleTask": {
                return Optional.ofNullable(clazz.cast(this.bundleTask()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<BundleTask>> map = new HashMap<String, SdkField<BundleTask>>();
        map.put("BundleInstanceTask", BUNDLE_TASK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BundleInstanceResponse, T> g) {
        return obj -> g.apply((BundleInstanceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private BundleTask bundleTask;

        private BuilderImpl() {
        }

        private BuilderImpl(BundleInstanceResponse model) {
            super(model);
            this.bundleTask(model.bundleTask);
        }

        public final BundleTask.Builder getBundleTask() {
            return this.bundleTask != null ? this.bundleTask.toBuilder() : null;
        }

        public final void setBundleTask(BundleTask.BuilderImpl bundleTask) {
            this.bundleTask = bundleTask != null ? bundleTask.build() : null;
        }

        @Override
        public final Builder bundleTask(BundleTask bundleTask) {
            this.bundleTask = bundleTask;
            return this;
        }

        @Override
        public BundleInstanceResponse build() {
            return new BundleInstanceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BundleInstanceResponse> {
        public Builder bundleTask(BundleTask var1);

        default public Builder bundleTask(Consumer<BundleTask.Builder> bundleTask) {
            return this.bundleTask((BundleTask)((BundleTask.Builder)BundleTask.builder().applyMutation(bundleTask)).build());
        }
    }
}

