"use strict";
// Copyright Amazon.com Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.EncryptedDataKey = void 0;
const immutable_class_1 = require("./immutable_class");
const needs_1 = require("./needs");
class EncryptedDataKey {
    constructor(edkInput) {
        const { providerInfo, providerId, encryptedDataKey, rawInfo } = edkInput;
        (0, needs_1.needs)(typeof providerInfo === 'string' &&
            providerInfo &&
            typeof providerId === 'string' &&
            providerId &&
            encryptedDataKey instanceof Uint8Array &&
            encryptedDataKey.byteLength, 'Malformed encrypted data key');
        (0, immutable_class_1.readOnlyProperty)(this, 'providerInfo', providerInfo);
        (0, immutable_class_1.readOnlyProperty)(this, 'providerId', providerId);
        (0, immutable_class_1.readOnlyBinaryProperty)(this, 'encryptedDataKey', encryptedDataKey);
        if (rawInfo instanceof Uint8Array) {
            (0, immutable_class_1.readOnlyBinaryProperty)(this, 'rawInfo', rawInfo);
        }
        else {
            (0, immutable_class_1.readOnlyProperty)(this, 'rawInfo', undefined);
        }
        Object.setPrototypeOf(this, EncryptedDataKey.prototype);
        Object.freeze(this);
    }
}
exports.EncryptedDataKey = EncryptedDataKey;
(0, immutable_class_1.frozenClass)(EncryptedDataKey);
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZW5jcnlwdGVkX2RhdGFfa2V5LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vc3JjL2VuY3J5cHRlZF9kYXRhX2tleS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiO0FBQUEsb0VBQW9FO0FBQ3BFLHNDQUFzQzs7O0FBRXRDLHVEQUkwQjtBQUMxQixtQ0FBK0I7QUFnQy9CLE1BQWEsZ0JBQWdCO0lBTTNCLFlBQVksUUFBMkI7UUFDckMsTUFBTSxFQUFFLFlBQVksRUFBRSxVQUFVLEVBQUUsZ0JBQWdCLEVBQUUsT0FBTyxFQUFFLEdBQUcsUUFBUSxDQUFBO1FBQ3hFLElBQUEsYUFBSyxFQUNILE9BQU8sWUFBWSxLQUFLLFFBQVE7WUFDOUIsWUFBWTtZQUNaLE9BQU8sVUFBVSxLQUFLLFFBQVE7WUFDOUIsVUFBVTtZQUNWLGdCQUFnQixZQUFZLFVBQVU7WUFDdEMsZ0JBQWdCLENBQUMsVUFBVSxFQUM3Qiw4QkFBOEIsQ0FDL0IsQ0FBQTtRQUVELElBQUEsa0NBQWdCLEVBQUMsSUFBSSxFQUFFLGNBQWMsRUFBRSxZQUFZLENBQUMsQ0FBQTtRQUNwRCxJQUFBLGtDQUFnQixFQUFDLElBQUksRUFBRSxZQUFZLEVBQUUsVUFBVSxDQUFDLENBQUE7UUFDaEQsSUFBQSx3Q0FBc0IsRUFBQyxJQUFJLEVBQUUsa0JBQWtCLEVBQUUsZ0JBQWdCLENBQUMsQ0FBQTtRQUNsRSxJQUFJLE9BQU8sWUFBWSxVQUFVLEVBQUU7WUFDakMsSUFBQSx3Q0FBc0IsRUFBQyxJQUFJLEVBQUUsU0FBUyxFQUFFLE9BQU8sQ0FBQyxDQUFBO1NBQ2pEO2FBQU07WUFDTCxJQUFBLGtDQUFnQixFQUFDLElBQUksRUFBRSxTQUFTLEVBQUUsU0FBUyxDQUFDLENBQUE7U0FDN0M7UUFFRCxNQUFNLENBQUMsY0FBYyxDQUFDLElBQUksRUFBRSxnQkFBZ0IsQ0FBQyxTQUFTLENBQUMsQ0FBQTtRQUN2RCxNQUFNLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxDQUFBO0lBQ3JCLENBQUM7Q0FDRjtBQTlCRCw0Q0E4QkM7QUFFRCxJQUFBLDZCQUFXLEVBQUMsZ0JBQWdCLENBQUMsQ0FBQSJ9