/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.lookup;

import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.search.IndexSearcher;
import org.opensearch.index.query.functionscore.TermFrequencyFunction;
import org.opensearch.index.query.functionscore.TermFrequencyFunctionFactory;
import org.opensearch.search.lookup.LeafSearchLookup;

public class LeafTermFrequencyLookup {
    private final IndexSearcher indexSearcher;
    private final LeafSearchLookup leafLookup;
    private final Map<String, TermFrequencyFunction> termFreqCache;

    public LeafTermFrequencyLookup(IndexSearcher indexSearcher, LeafSearchLookup leafLookup) {
        this.indexSearcher = indexSearcher;
        this.leafLookup = leafLookup;
        this.termFreqCache = new HashMap<String, TermFrequencyFunction>();
    }

    public Object getTermFrequency(TermFrequencyFunctionFactory.TermFrequencyFunctionName functionName, String field, String val, int docId) throws IOException {
        TermFrequencyFunction termFrequencyFunction = this.getOrCreateTermFrequencyFunction(functionName, field, val);
        return termFrequencyFunction.execute(docId);
    }

    private TermFrequencyFunction getOrCreateTermFrequencyFunction(TermFrequencyFunctionFactory.TermFrequencyFunctionName functionName, String field, String val) throws IOException {
        String cacheKey;
        String string = cacheKey = val == null ? String.format(Locale.ROOT, "%s-%s", new Object[]{functionName, field}) : String.format(Locale.ROOT, "%s-%s-%s", new Object[]{functionName, field, val});
        if (!this.termFreqCache.containsKey(cacheKey)) {
            TermFrequencyFunction termFrequencyFunction = TermFrequencyFunctionFactory.createFunction(functionName, field, val, this.leafLookup.ctx, this.indexSearcher);
            this.termFreqCache.put(cacheKey, termFrequencyFunction);
        }
        return this.termFreqCache.get(cacheKey);
    }
}

