/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

public abstract class DelegateAction
extends AbstractAction {
    private static final long serialVersionUID = -3867985431184738600L;
    private Action _action;
    private JComponent _target;

    public DelegateAction() {
    }

    public DelegateAction(Action action) {
        this._action = action;
    }

    public DelegateAction(Action action, JComponent target) {
        this._action = action;
        this._target = target;
    }

    @Override
    public boolean isEnabled() {
        return this.isDelegateEnabled() || this._action != null && this._action.isEnabled();
    }

    @Override
    public final void actionPerformed(ActionEvent e) {
        if (!this.delegateActionPerformed(e) && this._action != null) {
            if (this._target == null) {
                this._action.actionPerformed(e);
            } else {
                this._action.actionPerformed(new ActionEvent(this.getTarget(), e.getID(), e.getActionCommand(), e.getWhen(), e.getModifiers()));
            }
        }
    }

    protected Action getAction() {
        return this._action;
    }

    protected void setAction(Action action) {
        this._action = action;
    }

    protected JComponent getTarget() {
        return this._target;
    }

    protected void setTarget(JComponent target) {
        this._target = target;
    }

    public boolean isDelegateEnabled() {
        return super.isEnabled();
    }

    public abstract boolean delegateActionPerformed(ActionEvent var1);

    public static void replaceAction(JComponent component, int condition, KeyStroke keyStroke, DelegateAction delegateAction) {
        DelegateAction.replaceAction(component, condition, component, condition, keyStroke, delegateAction);
    }

    public static void replaceAction(JComponent component, int condition, KeyStroke keyStroke, DelegateAction delegateAction, boolean first) {
        DelegateAction.replaceAction(component, condition, component, condition, keyStroke, delegateAction, first);
    }

    public static void replaceAction(JComponent component, int condition, JComponent target, int targetCondition, KeyStroke keyStroke) {
        DelegateAction.replaceAction(component, condition, target, targetCondition, keyStroke, new PassthroughDelegateAction(), false);
    }

    public static void replaceAction(JComponent component, int condition, JComponent target, int targetCondition, KeyStroke keyStroke, DelegateAction delegateAction) {
        DelegateAction.replaceAction(component, condition, target, targetCondition, keyStroke, delegateAction, false);
    }

    public static void replaceAction(JComponent component, int condition, JComponent target, int targetCondition, KeyStroke keyStroke, DelegateAction delegateAction, boolean first) {
        ActionListener action = component.getActionForKeyStroke(keyStroke);
        if (action != delegateAction && action instanceof Action) {
            if (!first && action instanceof DelegateAction) {
                Action childAction = ((DelegateAction)action).getAction();
                while (childAction != null) {
                    if (childAction == delegateAction) {
                        return;
                    }
                    if (childAction instanceof DelegateAction) {
                        childAction = ((DelegateAction)childAction).getAction();
                        continue;
                    }
                    childAction = null;
                }
                delegateAction.setAction(((DelegateAction)action).getAction());
                ((DelegateAction)action).setAction(delegateAction);
                delegateAction = (DelegateAction)action;
            } else {
                delegateAction.setAction((Action)action);
            }
        }
        if (target != component) {
            delegateAction.setTarget(target);
            DelegateAction.replaceAction(component, condition, keyStroke, delegateAction);
        } else {
            Object actionCommand = target.getInputMap(targetCondition).get(keyStroke);
            if (actionCommand == null) {
                component.registerKeyboardAction(delegateAction, keyStroke, condition);
            } else {
                component.getActionMap().put(actionCommand, delegateAction);
            }
        }
    }

    public static void restoreAction(JComponent component, int condition, KeyStroke keyStroke) {
        if (component == null) {
            return;
        }
        ActionListener action = component.getActionForKeyStroke(keyStroke);
        if (action instanceof DelegateAction) {
            Action actualAction = ((DelegateAction)action).getAction();
            if (actualAction != null) {
                component.registerKeyboardAction(actualAction, keyStroke, condition);
            } else {
                component.unregisterKeyboardAction(keyStroke);
            }
        }
    }

    public static void restoreAction(JComponent component, int condition, KeyStroke keyStroke, Class<?> actionClass) {
        ActionListener action;
        ActionListener parent = action = component.getActionForKeyStroke(keyStroke);
        ActionListener top = action;
        while (action instanceof DelegateAction) {
            if (actionClass.isAssignableFrom(action.getClass())) {
                if (top == action) {
                    Action a = ((DelegateAction)action).getAction();
                    if (a == null) {
                        component.unregisterKeyboardAction(keyStroke);
                        break;
                    }
                    component.registerKeyboardAction(a, keyStroke, condition);
                    break;
                }
                ((DelegateAction)parent).setAction(((DelegateAction)action).getAction());
                break;
            }
            parent = action;
            action = ((DelegateAction)action).getAction();
        }
    }

    public static void restoreAction(JComponent component, int condition, KeyStroke keyStroke, Action actionToBeRemoved) {
        ActionListener action;
        ActionListener parent = action = component.getActionForKeyStroke(keyStroke);
        ActionListener top = action;
        while (action instanceof DelegateAction) {
            if (actionToBeRemoved == action) {
                if (top == action) {
                    Action oldAction = ((DelegateAction)action).getAction();
                    if (oldAction != null) {
                        Object name = component.getInputMap().get(keyStroke);
                        if (name != null) {
                            component.getActionMap().remove(name);
                            component.getActionMap().remove(action);
                        }
                        component.registerKeyboardAction(oldAction, keyStroke, condition);
                        break;
                    }
                    component.unregisterKeyboardAction(keyStroke);
                    break;
                }
                ((DelegateAction)parent).setAction(((DelegateAction)action).getAction());
                break;
            }
            parent = action;
            action = ((DelegateAction)action).getAction();
        }
    }

    public static class PassthroughDelegateAction
    extends DelegateAction {
        private static final long serialVersionUID = -1555177105658867899L;

        @Override
        public boolean delegateActionPerformed(ActionEvent e) {
            return false;
        }

        @Override
        public boolean isDelegateEnabled() {
            return false;
        }
    }
}

