/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jackson.spi;

import io.quarkus.builder.item.MultiBuildItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public final class JacksonModuleBuildItem
extends MultiBuildItem {
    private final String name;
    private final Collection<Item> items;

    public JacksonModuleBuildItem(String name, Collection<Item> items) {
        this.name = name;
        this.items = items;
    }

    public String getName() {
        return this.name;
    }

    public Collection<Item> getItems() {
        return this.items;
    }

    public static class Item {
        private final String targetClassName;
        private final String serializerClassName;
        private final String deserializerClassName;

        public Item(String targetClassName, String serializerClassName, String deserializerClassName) {
            this.serializerClassName = serializerClassName;
            this.deserializerClassName = deserializerClassName;
            if (targetClassName == null || targetClassName.isEmpty()) {
                throw new IllegalArgumentException("targetClassName cannot be null or empty");
            }
            this.targetClassName = targetClassName;
        }

        public String getSerializerClassName() {
            return this.serializerClassName;
        }

        public String getDeserializerClassName() {
            return this.deserializerClassName;
        }

        public String getTargetClassName() {
            return this.targetClassName;
        }
    }

    public static class Builder {
        private final String name;
        private final Map<String, String> targetClassToSerializer = new HashMap<String, String>();
        private final Map<String, String> targetClassToDeserializer = new HashMap<String, String>();

        public Builder(String name) {
            this.name = name;
        }

        public Builder addSerializer(String serializerClassName, String targetClassName) {
            this.targetClassToSerializer.put(targetClassName, serializerClassName);
            return this;
        }

        public Builder addDeserializer(String deserializerClassName, String targetClassName) {
            this.targetClassToDeserializer.put(targetClassName, deserializerClassName);
            return this;
        }

        public Builder add(String serializerClassName, String deserializerClassName, String targetClassName) {
            this.targetClassToSerializer.put(targetClassName, serializerClassName);
            this.targetClassToDeserializer.put(targetClassName, deserializerClassName);
            return this;
        }

        public JacksonModuleBuildItem build() {
            HashSet<String> allTargetClassNames = new HashSet<String>(this.targetClassToSerializer.keySet());
            allTargetClassNames.addAll(this.targetClassToDeserializer.keySet());
            ArrayList<Item> items = new ArrayList<Item>(this.targetClassToSerializer.size());
            for (String targetClassName : allTargetClassNames) {
                items.add(new Item(targetClassName, this.targetClassToSerializer.get(targetClassName), this.targetClassToDeserializer.get(targetClassName)));
            }
            return new JacksonModuleBuildItem(this.name, items);
        }
    }
}

