/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import sun.awt.SunToolkit;
import sun.font.GlyphDisposedListener;
import sun.font.GlyphList;
import sun.font.StrikeCache;
import sun.font.XRGlyphCacheEntry;
import sun.java2d.xr.GrowableIntArray;
import sun.java2d.xr.MutableInteger;
import sun.java2d.xr.XRBackend;
import sun.java2d.xr.XRCompositeManager;

public class XRGlyphCache
implements GlyphDisposedListener {
    XRBackend con;
    XRCompositeManager maskBuffer;
    HashMap<MutableInteger, XRGlyphCacheEntry> cacheMap = new HashMap(256);
    int nextID = 1;
    MutableInteger tmp = new MutableInteger(0);
    int grayGlyphSet;
    int lcdGlyphSet;
    int time = 0;
    int cachedPixels = 0;
    static final int MAX_CACHED_PIXELS = 100000;
    ArrayList<Integer> freeGlyphIDs = new ArrayList(255);
    static final boolean batchGlyphUpload = true;

    public XRGlyphCache(XRCompositeManager xRCompositeManager) {
        this.con = xRCompositeManager.getBackend();
        this.maskBuffer = xRCompositeManager;
        this.grayGlyphSet = this.con.XRenderCreateGlyphSet(2);
        this.lcdGlyphSet = this.con.XRenderCreateGlyphSet(0);
        StrikeCache.addGlyphDisposedListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void glyphDisposed(ArrayList<Long> arrayList) {
        try {
            SunToolkit.awtLock();
            GrowableIntArray growableIntArray = new GrowableIntArray(1, arrayList.size());
            for (long l : arrayList) {
                int n = XRGlyphCacheEntry.getGlyphID(l);
                if (n == 0) continue;
                growableIntArray.addInt(n);
            }
            this.freeGlyphs(growableIntArray);
        }
        finally {
            SunToolkit.awtUnlock();
        }
    }

    protected int getFreeGlyphID() {
        if (this.freeGlyphIDs.size() > 0) {
            int n = this.freeGlyphIDs.remove(this.freeGlyphIDs.size() - 1);
            return n;
        }
        return this.nextID++;
    }

    protected XRGlyphCacheEntry getEntryForPointer(long l) {
        int n = XRGlyphCacheEntry.getGlyphID(l);
        if (n == 0) {
            return null;
        }
        this.tmp.setValue(n);
        return this.cacheMap.get(this.tmp);
    }

    public XRGlyphCacheEntry[] cacheGlyphs(GlyphList glyphList) {
        ++this.time;
        XRGlyphCacheEntry[] xRGlyphCacheEntryArray = new XRGlyphCacheEntry[glyphList.getNumGlyphs()];
        long[] lArray = glyphList.getImages();
        ArrayList<XRGlyphCacheEntry> arrayList = null;
        for (int i = 0; i < glyphList.getNumGlyphs(); ++i) {
            if (lArray[i] == 0L) continue;
            XRGlyphCacheEntry xRGlyphCacheEntry = this.getEntryForPointer(lArray[i]);
            if (xRGlyphCacheEntry == null) {
                xRGlyphCacheEntry = new XRGlyphCacheEntry(lArray[i], glyphList);
                xRGlyphCacheEntry.setGlyphID(this.getFreeGlyphID());
                this.cacheMap.put(new MutableInteger(xRGlyphCacheEntry.getGlyphID()), xRGlyphCacheEntry);
                if (arrayList == null) {
                    arrayList = new ArrayList<XRGlyphCacheEntry>();
                }
                arrayList.add(xRGlyphCacheEntry);
            }
            xRGlyphCacheEntry.setLastUsed(this.time);
            xRGlyphCacheEntryArray[i] = xRGlyphCacheEntry;
        }
        if (arrayList != null) {
            this.uploadGlyphs(xRGlyphCacheEntryArray, arrayList, glyphList, null);
        }
        return xRGlyphCacheEntryArray;
    }

    protected void uploadGlyphs(XRGlyphCacheEntry[] xRGlyphCacheEntryArray, ArrayList<XRGlyphCacheEntry> arrayList, GlyphList glyphList, int[] nArray) {
        for (XRGlyphCacheEntry listArray2 : arrayList) {
            this.cachedPixels += listArray2.getPixelCnt();
        }
        if (this.cachedPixels > 100000) {
            this.clearCache(xRGlyphCacheEntryArray);
        }
        boolean bl = this.containsLCDGlyphs(arrayList);
        List<XRGlyphCacheEntry>[] listArray = this.seperateGlyphTypes(arrayList, bl);
        List<XRGlyphCacheEntry> list = listArray[0];
        List<XRGlyphCacheEntry> list2 = listArray[1];
        if (list != null && list.size() > 0) {
            this.con.XRenderAddGlyphs(this.grayGlyphSet, glyphList, list, this.generateGlyphImageStream(list));
        }
        if (list2 != null && list2.size() > 0) {
            this.con.XRenderAddGlyphs(this.lcdGlyphSet, glyphList, list2, this.generateGlyphImageStream(list2));
        }
    }

    protected List<XRGlyphCacheEntry>[] seperateGlyphTypes(List<XRGlyphCacheEntry> list, boolean bl) {
        ArrayList<XRGlyphCacheEntry> arrayList = null;
        ArrayList<XRGlyphCacheEntry> arrayList2 = null;
        for (XRGlyphCacheEntry xRGlyphCacheEntry : list) {
            if (xRGlyphCacheEntry.isGrayscale(bl)) {
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList<XRGlyphCacheEntry>(list.size());
                }
                xRGlyphCacheEntry.setGlyphSet(this.grayGlyphSet);
                arrayList2.add(xRGlyphCacheEntry);
                continue;
            }
            if (arrayList == null) {
                arrayList = new ArrayList<XRGlyphCacheEntry>(list.size());
            }
            xRGlyphCacheEntry.setGlyphSet(this.lcdGlyphSet);
            arrayList.add(xRGlyphCacheEntry);
        }
        return new List[]{arrayList2, arrayList};
    }

    protected byte[] generateGlyphImageStream(List<XRGlyphCacheEntry> list) {
        boolean bl = list.get(0).getGlyphSet() == this.lcdGlyphSet;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream((bl ? 4 : 1) * 48 * list.size());
        for (XRGlyphCacheEntry xRGlyphCacheEntry : list) {
            xRGlyphCacheEntry.writePixelData(byteArrayOutputStream, bl);
        }
        return byteArrayOutputStream.toByteArray();
    }

    protected boolean containsLCDGlyphs(List<XRGlyphCacheEntry> list) {
        boolean bl = false;
        for (XRGlyphCacheEntry xRGlyphCacheEntry : list) {
            bl = xRGlyphCacheEntry.getSourceRowBytes() != xRGlyphCacheEntry.getWidth();
            if (!bl) continue;
            return true;
        }
        return false;
    }

    protected void clearCache(XRGlyphCacheEntry[] xRGlyphCacheEntryArray) {
        ArrayList<XRGlyphCacheEntry> arrayList = new ArrayList<XRGlyphCacheEntry>(this.cacheMap.values());
        Collections.sort(arrayList, new Comparator<XRGlyphCacheEntry>(){

            @Override
            public int compare(XRGlyphCacheEntry xRGlyphCacheEntry, XRGlyphCacheEntry xRGlyphCacheEntry2) {
                return xRGlyphCacheEntry2.getLastUsed() - xRGlyphCacheEntry.getLastUsed();
            }
        });
        for (XRGlyphCacheEntry xRGlyphCacheEntry : xRGlyphCacheEntryArray) {
            xRGlyphCacheEntry.setPinned();
        }
        GrowableIntArray growableIntArray = new GrowableIntArray(1, 10);
        int n = this.cachedPixels - 100000;
        for (int i = arrayList.size() - 1; i >= 0 && n > 0; --i) {
            XRGlyphCacheEntry xRGlyphCacheEntry;
            xRGlyphCacheEntry = arrayList.get(i);
            if (xRGlyphCacheEntry.isPinned()) continue;
            n -= xRGlyphCacheEntry.getPixelCnt();
            growableIntArray.addInt(xRGlyphCacheEntry.getGlyphID());
        }
        for (XRGlyphCacheEntry xRGlyphCacheEntry : xRGlyphCacheEntryArray) {
            xRGlyphCacheEntry.setUnpinned();
        }
        this.freeGlyphs(growableIntArray);
    }

    private void freeGlyphs(GrowableIntArray growableIntArray) {
        GrowableIntArray growableIntArray2 = new GrowableIntArray(1, 10);
        GrowableIntArray growableIntArray3 = new GrowableIntArray(1, 10);
        for (int i = 0; i < growableIntArray.getSize(); ++i) {
            int n = growableIntArray.getInt(i);
            this.freeGlyphIDs.add(n);
            this.tmp.setValue(n);
            XRGlyphCacheEntry xRGlyphCacheEntry = this.cacheMap.get(this.tmp);
            this.cachedPixels -= xRGlyphCacheEntry.getPixelCnt();
            this.cacheMap.remove(this.tmp);
            if (xRGlyphCacheEntry.getGlyphSet() == this.grayGlyphSet) {
                growableIntArray3.addInt(n);
            } else {
                growableIntArray2.addInt(n);
            }
            xRGlyphCacheEntry.setGlyphID(0);
        }
        if (growableIntArray3.getSize() > 0) {
            this.con.XRenderFreeGlyphs(this.grayGlyphSet, growableIntArray3.getSizedArray());
        }
        if (growableIntArray2.getSize() > 0) {
            this.con.XRenderFreeGlyphs(this.lcdGlyphSet, growableIntArray2.getSizedArray());
        }
    }
}

