/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon.client;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.daemon.client.DaemonProblemReportingOutputListener;
import org.jetbrains.kotlin.daemon.client.KotlinCompilerClient;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/daemon/client/DaemonGcAutoConfigurationProblemsListener;", "Lorg/jetbrains/kotlin/daemon/client/DaemonProblemReportingOutputListener;", "gcAutoConfiguration", "Lorg/jetbrains/kotlin/daemon/client/KotlinCompilerClient$GcAutoConfiguration;", "startupAttempt", "", "(Lorg/jetbrains/kotlin/daemon/client/KotlinCompilerClient$GcAutoConfiguration;I)V", "hasGcSelectionProblems", "", "onOutputLine", "", "line", "", "retrieveProblems", "", "kotlin-daemon-client"})
public final class DaemonGcAutoConfigurationProblemsListener
implements DaemonProblemReportingOutputListener {
    @NotNull
    private final KotlinCompilerClient.GcAutoConfiguration gcAutoConfiguration;
    private final int startupAttempt;
    private boolean hasGcSelectionProblems;

    public DaemonGcAutoConfigurationProblemsListener(@NotNull KotlinCompilerClient.GcAutoConfiguration gcAutoConfiguration, int startupAttempt) {
        Intrinsics.checkNotNullParameter((Object)gcAutoConfiguration, (String)"gcAutoConfiguration");
        this.gcAutoConfiguration = gcAutoConfiguration;
        this.startupAttempt = startupAttempt;
    }

    @Override
    public void onOutputLine(@NotNull String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        if (!this.gcAutoConfiguration.getShouldAutoConfigureGc()) {
            return;
        }
        if (StringsKt.contains$default((CharSequence)line, (CharSequence)"Multiple garbage collectors selected", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)line, (CharSequence)"Conflicting collector combinations in option list", (boolean)false, (int)2, null)) {
            this.hasGcSelectionProblems = true;
            this.gcAutoConfiguration.setShouldAutoConfigureGc(false);
        }
    }

    @Override
    @NotNull
    public List<String> retrieveProblems() {
        boolean shouldReport;
        boolean bl;
        if (this.hasGcSelectionProblems) {
            bl = true;
        } else if (this.gcAutoConfiguration.getShouldAutoConfigureGc() && this.startupAttempt >= 1) {
            this.gcAutoConfiguration.setShouldAutoConfigureGc(false);
            bl = true;
        } else {
            bl = shouldReport = false;
        }
        if (!shouldReport) {
            return CollectionsKt.emptyList();
        }
        Object[] objectArray = new String[]{"Problems may have occurred during auto-selection of GC. The preferred GC is " + this.gcAutoConfiguration.getPreferredGc() + " GC.", "If the problems persist, try adding the JVM option to the Kotlin daemon JVM arguments: -XX:-Use" + this.gcAutoConfiguration.getPreferredGc() + "GC.", "GC auto-selection logic is disabled temporary for the next daemon startup."};
        return CollectionsKt.listOf((Object[])objectArray);
    }
}

