/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.util.logging.headers;

import java.util.Date;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.util.logging.OutputController;
import net.sourceforge.jnlp.util.logging.TeeOutputStream;

public class Header {
    public static String default_user = System.getProperty("user.name");
    public String user = default_user;
    public boolean application = true;
    public OutputController.Level level = OutputController.Level.WARNING_ALL;
    public Date timestamp = new Date();
    public String date = this.timestamp.toString();
    public boolean isC = false;
    public boolean isClientApp = false;
    public String caller = "unknown";
    public String thread1 = "unknown";
    public String thread2 = "unknown";
    private static final String CLIENT = "CLIENT";

    public Header() {
    }

    public Header(OutputController.Level level, boolean isC) {
        this(level, Thread.currentThread().getStackTrace(), Thread.currentThread(), isC);
    }

    public Header(OutputController.Level level, StackTraceElement[] stack, Thread thread, boolean isC) {
        this(level, stack, thread, new Date(), isC);
    }

    public Header(OutputController.Level level, StackTraceElement[] stack, Thread thread, Date d, boolean isC) {
        this.application = JNLPRuntime.isWebstartApplication();
        this.level = level;
        this.timestamp = d;
        this.date = this.timestamp.toString();
        this.isC = isC;
        if (stack != null) {
            this.caller = Header.getCallerClass(stack);
        }
        this.thread1 = Integer.toHexString(thread.hashCode());
        this.thread2 = thread.getName();
    }

    public String toString() {
        return this.toString(true, true, true, true, true, true, true);
    }

    public String toString(boolean userb, boolean originb, boolean levelb, boolean dateb, boolean callerb, boolean thread1b, boolean thread2b) {
        StringBuilder sb = new StringBuilder();
        try {
            if (userb) {
                sb.append("[").append(this.user).append("]");
            }
            if (originb) {
                sb.append("[").append(this.getOrigin()).append("]");
            }
            if (levelb && this.level != null) {
                sb.append('[').append(this.level.toString()).append(']');
            }
            if (dateb) {
                sb.append('[').append(this.date.toString()).append(']');
            }
            if (callerb && this.caller != null) {
                sb.append('[').append(this.caller).append(']');
            }
            if (thread1b && thread2b) {
                sb.append(this.threadsToString());
            } else if (thread1b) {
                sb.append(this.thread1ToString());
            } else if (thread2b) {
                sb.append(this.thread2ToString());
            }
        }
        catch (Exception ex) {
            OutputController.getLogger().log(ex);
        }
        return sb.toString();
    }

    public String thread1ToString() {
        return " NETX Thread# " + this.thread1;
    }

    public String thread2ToString() {
        return "name " + this.thread2;
    }

    public String threadsToString() {
        return this.thread1ToString() + ", " + this.thread2ToString();
    }

    public String getOrigin() {
        String s = this.application ? "ITW-JAVAWS" : (this.isC ? "ITW-C-PLUGIN" : "ITW-APPLET");
        if (this.isClientApp) {
            s = s + "-" + CLIENT;
        }
        return s;
    }

    static String getCallerClass(StackTraceElement[] stack) {
        try {
            StackTraceElement result = stack[0];
            for (int i = 1; i < stack.length; ++i) {
                result = stack[i];
                if (!stack[i].getClassName().contains(OutputController.class.getName()) && !stack[i].getClassName().contains("sun.applet.PluginDebug") && !stack[i].getClassName().contains(Header.class.getName()) && !stack[i].getClassName().contains(TeeOutputStream.class.getName())) break;
            }
            return result.toString();
        }
        catch (Exception ex) {
            OutputController.getLogger().log(ex);
            return "Unknown caller";
        }
    }
}

