/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.parser;

import io.sf.carte.doc.style.css.nsac.AttributeCondition;
import io.sf.carte.doc.style.css.nsac.CSSException;
import io.sf.carte.doc.style.css.nsac.CombinatorSelector;
import io.sf.carte.doc.style.css.nsac.Condition;
import io.sf.carte.doc.style.css.nsac.ElementSelector;
import io.sf.carte.doc.style.css.nsac.Parser;
import io.sf.carte.doc.style.css.nsac.Selector;
import io.sf.carte.doc.style.css.nsac.SimpleSelector;
import io.sf.carte.doc.style.css.parser.AbstractSelector;
import io.sf.carte.doc.style.css.parser.CombinatorConditionImpl;
import io.sf.carte.doc.style.css.parser.ConditionalSelectorImpl;
import io.sf.carte.doc.style.css.parser.LangConditionImpl;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import io.sf.carte.doc.style.css.parser.PositionalConditionImpl;
import io.sf.carte.doc.style.css.parser.PseudoConditionImpl;
import io.sf.carte.doc.style.css.parser.ScopeSelector;
import io.sf.carte.doc.style.css.parser.SelectorArgumentConditionImpl;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

class NSACSelectorFactory
implements Parser.NamespaceMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final ElementSelector universalSelector = new AnyNodeSelector();
    private HashMap<String, String> mapNsPrefix2Uri = null;

    NSACSelectorFactory() {
    }

    ElementSelector getUniversalSelector(String string) {
        if (string == null) {
            return universalSelector;
        }
        return this.createUniversalSelector(this.getNamespaceURI(string));
    }

    static ElementSelector getUniversalSelector() {
        return universalSelector;
    }

    ElementSelector createUniversalSelector(String string) {
        return new UniversalSelector(string);
    }

    ElementSelectorImpl createElementSelector() {
        return new ElementSelectorImpl();
    }

    CombinatorSelectorImpl createCombinatorSelector(Selector.SelectorType selectorType, Selector selector) {
        if (selector == null) {
            selector = NSACSelectorFactory.getUniversalSelector();
        }
        return new CombinatorSelectorImpl(selectorType, selector);
    }

    ConditionalSelectorImpl createConditionalSelector(SimpleSelector simpleSelector, Condition condition) throws CSSException {
        if (simpleSelector == null) {
            simpleSelector = NSACSelectorFactory.getUniversalSelector();
        }
        return new ConditionalSelectorImpl(simpleSelector, condition);
    }

    Selector createScopeSelector() {
        return new ScopeSelector();
    }

    void registerNamespacePrefix(String string, String string2) {
        if (this.mapNsPrefix2Uri == null) {
            this.mapNsPrefix2Uri = new HashMap();
        }
        this.mapNsPrefix2Uri.put(string, string2);
    }

    @Override
    public String getNamespaceURI(String string) {
        return this.mapNsPrefix2Uri != null ? this.mapNsPrefix2Uri.get(string) : null;
    }

    String getNamespacePrefix(String string) {
        for (Map.Entry<String, String> entry : this.mapNsPrefix2Uri.entrySet()) {
            if (!string.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    PositionalConditionImpl createPositionalCondition() {
        return new PositionalConditionImpl(false);
    }

    PositionalConditionImpl createPositionalCondition(boolean bl) {
        PositionalConditionImpl positionalConditionImpl = new PositionalConditionImpl(bl);
        return positionalConditionImpl;
    }

    Condition createCondition(Condition.ConditionType conditionType) {
        switch (conditionType) {
            case CLASS: {
                AttributeConditionImpl attributeConditionImpl = new AttributeConditionImpl(conditionType);
                return attributeConditionImpl;
            }
            case ATTRIBUTE: 
            case BEGIN_HYPHEN_ATTRIBUTE: 
            case ONE_OF_ATTRIBUTE: 
            case ENDS_ATTRIBUTE: 
            case SUBSTRING_ATTRIBUTE: 
            case BEGINS_ATTRIBUTE: 
            case ID: 
            case ONLY_CHILD: 
            case ONLY_TYPE: {
                return new AttributeConditionImpl(conditionType);
            }
            case PSEUDO_CLASS: 
            case PSEUDO_ELEMENT: {
                return new PseudoConditionImpl(conditionType);
            }
            case LANG: {
                return new LangConditionImpl();
            }
            case AND: {
                return new CombinatorConditionImpl();
            }
            case SELECTOR_ARGUMENT: {
                return new SelectorArgumentConditionImpl();
            }
            case POSITIONAL: {
                return this.createPositionalCondition();
            }
        }
        return null;
    }

    static String escapeName(String string) {
        return string != null ? ParseHelper.escape(string, false, false) : "";
    }

    static class AnyNodeSelector
    extends AbstractSelector
    implements ElementSelector {
        private static final long serialVersionUID = 1L;

        AnyNodeSelector() {
        }

        @Override
        public Selector.SelectorType getSelectorType() {
            return Selector.SelectorType.UNIVERSAL;
        }

        @Override
        public String getLocalName() {
            return "*";
        }

        @Override
        public String getNamespaceURI() {
            return null;
        }

        @Override
        public int hashCode() {
            int n = 31;
            int n2 = super.hashCode();
            n2 = 31 * n2 + "*".hashCode();
            return n2;
        }

        public String toString() {
            return "*";
        }
    }

    class AttributeConditionImpl
    implements AttributeCondition,
    Serializable {
        private static final long serialVersionUID = 1L;
        Condition.ConditionType type;
        private String namespaceURI = null;
        private String localName = null;
        private String value = null;
        private AttributeCondition.Flag flag = null;

        AttributeConditionImpl(Condition.ConditionType conditionType) {
            this.type = conditionType;
        }

        @Override
        public Condition.ConditionType getConditionType() {
            return this.type;
        }

        @Override
        public String getNamespaceURI() {
            return this.namespaceURI;
        }

        void setNamespaceURI(String string) {
            this.namespaceURI = string;
        }

        @Override
        public String getLocalName() {
            return this.localName;
        }

        void setLocalName(String string) {
            this.localName = string;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        void setValue(String string) {
            this.value = string;
        }

        @Override
        public boolean hasFlag(AttributeCondition.Flag flag) {
            return this.flag == flag;
        }

        void setFlag(AttributeCondition.Flag flag) {
            this.flag = flag;
        }

        public int hashCode() {
            int n = 31;
            int n2 = 1;
            n2 = 31 * n2 + (this.flag == null ? 0 : this.flag.hashCode());
            n2 = 31 * n2 + (this.localName == null ? 0 : this.localName.hashCode());
            n2 = 31 * n2 + (this.namespaceURI == null ? 0 : this.namespaceURI.hashCode());
            n2 = 31 * n2 + this.type.hashCode();
            n2 = 31 * n2 + (this.value == null ? 0 : this.value.hashCode());
            return n2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            AttributeConditionImpl attributeConditionImpl = (AttributeConditionImpl)object;
            if (this.flag != attributeConditionImpl.flag) {
                return false;
            }
            if (this.localName == null ? attributeConditionImpl.localName != null : !this.localName.equals(attributeConditionImpl.localName)) {
                return false;
            }
            if (this.namespaceURI == null ? attributeConditionImpl.namespaceURI != null : !this.namespaceURI.equals(attributeConditionImpl.namespaceURI)) {
                return false;
            }
            if (this.type != attributeConditionImpl.type) {
                return false;
            }
            return !(this.value == null ? attributeConditionImpl.value != null : !this.value.equals(attributeConditionImpl.value));
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            Condition.ConditionType conditionType = this.getConditionType();
            switch (conditionType) {
                case ATTRIBUTE: {
                    stringBuilder.append('[');
                    this.appendEscapedQName(stringBuilder);
                    if (this.value != null) {
                        stringBuilder.append('=').append('\"').append(this.getControlEscapedValue()).append('\"');
                        if (this.flag == AttributeCondition.Flag.CASE_I) {
                            stringBuilder.append(' ').append('i');
                        } else if (this.flag == AttributeCondition.Flag.CASE_S) {
                            stringBuilder.append(' ').append('s');
                        }
                    }
                    stringBuilder.append(']');
                    break;
                }
                case BEGIN_HYPHEN_ATTRIBUTE: {
                    stringBuilder.append('[');
                    this.appendEscapedQName(stringBuilder);
                    stringBuilder.append('|').append('=').append('\"').append(this.getControlEscapedValue()).append('\"');
                    stringBuilder.append(']');
                    break;
                }
                case ONE_OF_ATTRIBUTE: {
                    stringBuilder.append('[');
                    this.appendEscapedQName(stringBuilder);
                    stringBuilder.append('~').append('=').append('\"').append(this.getControlEscapedValue()).append('\"');
                    stringBuilder.append(']');
                    break;
                }
                case BEGINS_ATTRIBUTE: {
                    stringBuilder.append('[');
                    this.appendEscapedQName(stringBuilder);
                    stringBuilder.append('^').append('=').append('\"').append(this.getControlEscapedValue()).append('\"');
                    stringBuilder.append(']');
                    break;
                }
                case ENDS_ATTRIBUTE: {
                    stringBuilder.append('[');
                    this.appendEscapedQName(stringBuilder);
                    stringBuilder.append('$').append('=').append('\"').append(this.getControlEscapedValue()).append('\"');
                    stringBuilder.append(']');
                    break;
                }
                case SUBSTRING_ATTRIBUTE: {
                    stringBuilder.append('[');
                    this.appendEscapedQName(stringBuilder);
                    stringBuilder.append('*').append('=').append('\"').append(this.getControlEscapedValue()).append('\"');
                    stringBuilder.append(']');
                    break;
                }
                case CLASS: {
                    stringBuilder.append('.').append(this.getEscapedValue());
                    break;
                }
                case ID: {
                    stringBuilder.append('#').append(this.getEscapedValue());
                    break;
                }
                case LANG: {
                    stringBuilder.append(":lang(").append(this.getEscapedValue()).append(')');
                    break;
                }
                case ONLY_CHILD: {
                    stringBuilder.append(":only-child");
                    break;
                }
                case ONLY_TYPE: {
                    stringBuilder.append(":only-of-type");
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown type: " + (Object)((Object)conditionType));
                }
            }
            return stringBuilder.toString();
        }

        private void appendEscapedQName(StringBuilder stringBuilder) {
            if (this.namespaceURI != null) {
                if (this.namespaceURI.length() != 0) {
                    String string = NSACSelectorFactory.this.getNamespacePrefix(this.namespaceURI);
                    if (string != null && string.length() != 0) {
                        stringBuilder.append(string).append("|");
                    }
                } else {
                    stringBuilder.append("|");
                }
            }
            if (this.localName != null) {
                stringBuilder.append(NSACSelectorFactory.escapeName(this.localName));
            }
        }

        private String getEscapedValue() {
            return this.value != null ? ParseHelper.escape(this.value, false, false) : "";
        }

        private String getControlEscapedValue() {
            return this.value != null ? ParseHelper.escapeControl(ParseHelper.escapeBackslash(this.value)) : "";
        }
    }

    static class CombinatorSelectorImpl
    extends AbstractSelector
    implements CombinatorSelector {
        private static final long serialVersionUID = 1L;
        private Selector.SelectorType type;
        SimpleSelector simpleSelector = null;
        Selector selector;

        CombinatorSelectorImpl(Selector.SelectorType selectorType, Selector selector) {
            this.type = selectorType;
            this.selector = selector;
        }

        @Override
        public Selector.SelectorType getSelectorType() {
            return this.type;
        }

        void setSelectorType(Selector.SelectorType selectorType) {
            this.type = selectorType;
        }

        @Override
        public Selector getSelector() {
            return this.selector;
        }

        @Override
        public SimpleSelector getSecondSelector() {
            return this.simpleSelector;
        }

        @Override
        public int hashCode() {
            int n = 31;
            int n2 = super.hashCode();
            n2 = 31 * n2 + (this.selector == null ? 0 : this.selector.hashCode());
            n2 = 31 * n2 + (this.simpleSelector == null ? 0 : this.simpleSelector.hashCode());
            n2 = 31 * n2 + this.type.hashCode();
            return n2;
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!super.equals(object)) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            CombinatorSelectorImpl combinatorSelectorImpl = (CombinatorSelectorImpl)object;
            if (this.selector == null ? combinatorSelectorImpl.selector != null : !this.selector.equals(combinatorSelectorImpl.selector)) {
                return false;
            }
            if (this.simpleSelector == null ? combinatorSelectorImpl.simpleSelector != null : !this.simpleSelector.equals(combinatorSelectorImpl.simpleSelector)) {
                return false;
            }
            return this.type == combinatorSelectorImpl.type;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.selector.toString());
            switch (this.type) {
                case DIRECT_ADJACENT: {
                    stringBuilder.append('+');
                    break;
                }
                case SUBSEQUENT_SIBLING: {
                    stringBuilder.append('~');
                    break;
                }
                case CHILD: {
                    stringBuilder.append('>');
                    break;
                }
                case DESCENDANT: {
                    if (this.selector.getSelectorType() != Selector.SelectorType.SCOPE_MARKER) {
                        stringBuilder.append(' ');
                        break;
                    }
                    stringBuilder.append(">>");
                    break;
                }
                case COLUMN_COMBINATOR: {
                    stringBuilder.append("||");
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown type: " + (Object)((Object)this.type));
                }
            }
            if (this.simpleSelector != null) {
                stringBuilder.append(this.simpleSelector.toString());
            } else {
                stringBuilder.append('?');
            }
            return stringBuilder.toString();
        }
    }

    class ElementSelectorImpl
    extends AbstractSelector
    implements ElementSelector {
        private static final long serialVersionUID = 1L;
        String namespaceUri = null;
        String localName = null;

        ElementSelectorImpl() {
        }

        void setNamespaceUri(String string) {
            this.namespaceUri = string;
        }

        void setLocalName(String string) {
            this.localName = string;
        }

        @Override
        public Selector.SelectorType getSelectorType() {
            return Selector.SelectorType.ELEMENT;
        }

        @Override
        public String getNamespaceURI() {
            return this.namespaceUri;
        }

        @Override
        public String getLocalName() {
            return this.localName;
        }

        @Override
        public int hashCode() {
            int n = 31;
            int n2 = super.hashCode();
            n2 = 31 * n2 + (this.getLocalName() == null ? 0 : this.getLocalName().hashCode());
            n2 = 31 * n2 + (this.namespaceUri == null ? 0 : this.namespaceUri.hashCode());
            return n2;
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!super.equals(object)) {
                return false;
            }
            if (!(object instanceof ElementSelector)) {
                return false;
            }
            ElementSelector elementSelector = (ElementSelector)object;
            if (this.getLocalName() == null ? elementSelector.getLocalName() != null : !this.getLocalName().equals(elementSelector.getLocalName())) {
                return false;
            }
            return !(this.getNamespaceURI() == null ? elementSelector.getNamespaceURI() != null : !this.getNamespaceURI().equals(elementSelector.getNamespaceURI()));
        }

        public String toString() {
            String string = this.getLocalName();
            if (string != null) {
                string = NSACSelectorFactory.escapeName(string);
            }
            if (this.namespaceUri != null) {
                if (this.namespaceUri.length() != 0) {
                    String string2 = NSACSelectorFactory.this.getNamespacePrefix(this.namespaceUri);
                    if (string2 != null && string2.length() != 0) {
                        return string2 + "|" + string;
                    }
                } else {
                    return "|" + string;
                }
            }
            return string;
        }
    }

    class UniversalSelector
    extends ElementSelectorImpl {
        private static final long serialVersionUID = 1L;

        UniversalSelector(String string) {
            this.namespaceUri = string;
        }

        @Override
        public Selector.SelectorType getSelectorType() {
            return Selector.SelectorType.UNIVERSAL;
        }

        @Override
        public String getLocalName() {
            return "*";
        }

        @Override
        public String toString() {
            if (this.namespaceUri == null) {
                return "*";
            }
            return NSACSelectorFactory.this.getNamespacePrefix(this.namespaceUri) + "|*";
        }
    }
}

