/*
 * Decompiled with CFR 0.152.
 */
package firrtl.annotations;

import firrtl.annotations.AnnotationUtils$;
import firrtl.annotations.CircuitName;
import firrtl.annotations.CircuitTarget;
import firrtl.annotations.CompleteTarget;
import firrtl.annotations.ComponentName;
import firrtl.annotations.GenericTarget;
import firrtl.annotations.InstanceTarget;
import firrtl.annotations.IsComponent;
import firrtl.annotations.IsMember;
import firrtl.annotations.ModuleName;
import firrtl.annotations.ModuleTarget;
import firrtl.annotations.Named;
import firrtl.annotations.ReferenceTarget;
import firrtl.annotations.Target;
import firrtl.annotations.TargetToken;
import firrtl.annotations.TargetToken$Clock$;
import firrtl.annotations.TargetToken$Init$;
import firrtl.annotations.TargetToken$Reset$;
import firrtl.ir.DoPrim;
import firrtl.ir.Expression;
import firrtl.ir.Literal;
import firrtl.ir.Mux;
import firrtl.ir.Reference;
import firrtl.ir.SubAccess;
import firrtl.ir.SubField;
import firrtl.ir.SubIndex;
import firrtl.ir.ValidIf;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.AbstractIterable;
import scala.collection.AbstractSeq;
import scala.collection.ArrayOps$;
import scala.collection.IndexedSeqOps;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class Target$ {
    public static final Target$ MODULE$ = new Target$();

    public ReferenceTarget asTarget(ModuleTarget m, Expression e) {
        ReferenceTarget referenceTarget;
        Expression expression = e;
        if (expression instanceof Reference) {
            Reference reference = (Reference)expression;
            referenceTarget = m.ref(reference.name());
        } else if (expression instanceof SubIndex) {
            SubIndex subIndex = (SubIndex)expression;
            referenceTarget = this.asTarget(m, subIndex.expr()).index(subIndex.value());
        } else if (expression instanceof SubField) {
            SubField subField = (SubField)expression;
            referenceTarget = this.asTarget(m, subField.expr()).field(subField.name());
        } else if (expression instanceof SubAccess) {
            SubAccess subAccess = (SubAccess)expression;
            referenceTarget = this.asTarget(m, subAccess.expr()).field(new StringBuilder(1).append("@").append(subAccess.index().serialize()).toString());
        } else if (expression instanceof DoPrim) {
            DoPrim doPrim = (DoPrim)expression;
            referenceTarget = m.ref(new StringBuilder(1).append("@").append(doPrim.serialize()).toString());
        } else if (expression instanceof Mux) {
            Mux mux = (Mux)expression;
            referenceTarget = m.ref(new StringBuilder(1).append("@").append(mux.serialize()).toString());
        } else if (expression instanceof ValidIf) {
            ValidIf validIf = (ValidIf)expression;
            referenceTarget = m.ref(new StringBuilder(1).append("@").append(validIf.serialize()).toString());
        } else if (expression instanceof Literal) {
            Literal literal = (Literal)expression;
            referenceTarget = m.ref(new StringBuilder(1).append("@").append(literal.serialize()).toString());
        } else {
            throw scala.sys.package$.MODULE$.error(new StringBuilder(13).append("Unsupported: ").append(expression).toString());
        }
        return referenceTarget;
    }

    public GenericTarget apply(Option<String> circuitOpt, Option<String> moduleOpt, Seq<TargetToken> reference) {
        return new GenericTarget(circuitOpt, moduleOpt, reference.toVector());
    }

    public Option<Tuple3<Option<String>, Option<String>, Seq<TargetToken>>> unapply(Target t) {
        return new Some<Tuple3<Option<String>, Option<String>, Seq<TargetToken>>>(new Tuple3<Option<String>, Option<String>, Seq<TargetToken>>(t.circuitOpt(), t.moduleOpt(), t.tokens()));
    }

    public CircuitName convertCircuitTarget2CircuitName(CircuitTarget c) {
        return c.toNamed();
    }

    public ModuleName convertModuleTarget2ModuleName(ModuleTarget c) {
        return c.toNamed();
    }

    public ComponentName convertIsComponent2ComponentName(IsComponent c) {
        return c.toNamed();
    }

    public Named convertTarget2Named(Target c) {
        return c.toNamed();
    }

    public CircuitTarget convertCircuitName2CircuitTarget(CircuitName c) {
        return c.toTarget();
    }

    public ModuleTarget convertModuleName2ModuleTarget(ModuleName c) {
        return c.toTarget();
    }

    public ReferenceTarget convertComponentName2ReferenceTarget(ComponentName c) {
        return c.toTarget();
    }

    public CompleteTarget convertNamed2Target(Named n) {
        return n.toTarget();
    }

    public Seq<TargetToken> toTargetTokens(String name) {
        ArrayBuffer subComps;
        block0: {
            Seq<String> tokens = AnnotationUtils$.MODULE$.tokenize(name);
            subComps = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            subComps.$plus$eq(new TargetToken.Ref((String)tokens.head()));
            if (!((IterableOnceOps)tokens.tail()).nonEmpty()) break block0;
            ((IterableOnceOps)((IterableOps)tokens.tail()).zip((IterableOnce)((IterableOps)tokens.tail()).tail())).foreach((Function1<Tuple2, Object> & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String string = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    if (".".equals(string) && value != null) {
                        String string2 = value;
                        return subComps.$plus$eq(new TargetToken.Field(string2));
                    }
                }
                if (tuple2 == null) return BoxedUnit.UNIT;
                String string = (String)tuple2._1();
                String value = (String)tuple2._2();
                if (!"[".equals(string)) return BoxedUnit.UNIT;
                if (value == null) return BoxedUnit.UNIT;
                String string3 = value;
                return subComps.$plus$eq(new TargetToken.Index(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(string3))));
            });
        }
        return subComps.toSeq();
    }

    public boolean isOnly(Seq<TargetToken> seq, Seq<String> keywords) {
        return BoxesRunTime.unboxToBoolean(((IterableOnceOps)seq.map((Function1<TargetToken, Object> & Serializable)x$1 -> BoxesRunTime.boxToBoolean(x$1.is(keywords)))).foldLeft(BoxesRunTime.boxToBoolean(false), (Function2<Object, Object, Object> & Serializable)(x$2, x$3) -> BoxesRunTime.boxToBoolean(Target$.$anonfun$isOnly$2(BoxesRunTime.unboxToBoolean(x$2), BoxesRunTime.unboxToBoolean(x$3))))) && keywords.nonEmpty();
    }

    public Target deserialize(String s) {
        String regex = "(?=[~|>/:.\\[@])";
        return ((Target)ArrayOps$.MODULE$.foldLeft$extension(Predef$.MODULE$.refArrayOps(s.split(regex)), new GenericTarget(None$.MODULE$, None$.MODULE$, (Vector<TargetToken>)package$.MODULE$.Vector().empty()), (Function2<GenericTarget, String, GenericTarget> & Serializable)(t, tokenString) -> {
            String value = StringOps$.MODULE$.tail$extension(Predef$.MODULE$.augmentString((String)tokenString));
            char c = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString((String)tokenString), 0);
            switch (c) {
                case '~': {
                    GenericTarget genericTarget;
                    if (!t.circuitOpt().isEmpty() || !t.moduleOpt().isEmpty() || !((AbstractSeq)((Object)t.tokens())).isEmpty()) throw new Target.NamedException(new StringBuilder(27).append("Cannot deserialize Target: ").append(s).toString());
                    String string = value;
                    String string2 = "???";
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        genericTarget = t;
                        return genericTarget;
                    }
                    genericTarget = t.copy(new Some<String>(value), t.copy$default$2(), t.copy$default$3());
                    return genericTarget;
                }
                case '|': {
                    GenericTarget genericTarget;
                    if (!t.moduleOpt().isEmpty() || !((AbstractSeq)((Object)t.tokens())).isEmpty()) throw new Target.NamedException(new StringBuilder(27).append("Cannot deserialize Target: ").append(s).toString());
                    String string = value;
                    String string3 = "???";
                    if (!(string != null ? !string.equals(string3) : string3 != null)) {
                        genericTarget = t;
                        return genericTarget;
                    }
                    Some<String> x$1 = new Some<String>(value);
                    Option<String> x$2 = t.copy$default$1();
                    Vector<TargetToken> x$3 = t.copy$default$3();
                    genericTarget = t.copy(x$2, x$1, x$3);
                    return genericTarget;
                }
                case '/': {
                    GenericTarget genericTarget = t.add(new TargetToken.Instance(value));
                    return genericTarget;
                }
                case ':': {
                    GenericTarget genericTarget = t.add(new TargetToken.OfModule(value));
                    return genericTarget;
                }
                case '>': {
                    GenericTarget genericTarget = t.add(new TargetToken.Ref(value));
                    return genericTarget;
                }
                case '.': {
                    GenericTarget genericTarget = t.add(new TargetToken.Field(value));
                    return genericTarget;
                }
                case '[': {
                    if (StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(value), 1))) < 0) throw new Target.NamedException(new StringBuilder(27).append("Cannot deserialize Target: ").append(s).toString());
                    GenericTarget genericTarget = t.add(new TargetToken.Index(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(value), 1)))));
                    return genericTarget;
                }
                case '@': {
                    GenericTarget genericTarget;
                    String string = value;
                    String string4 = "clock";
                    if (!(string != null ? !string.equals(string4) : string4 != null)) {
                        genericTarget = t.add(TargetToken$Clock$.MODULE$);
                        return genericTarget;
                    }
                    String string5 = value;
                    String string6 = "init";
                    if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                        genericTarget = t.add(TargetToken$Init$.MODULE$);
                        return genericTarget;
                    }
                    String string7 = value;
                    String string8 = "reset";
                    if (string7 != null ? !string7.equals(string8) : string8 != null) throw new Target.NamedException(new StringBuilder(27).append("Cannot deserialize Target: ").append(s).toString());
                    genericTarget = t.add(TargetToken$Reset$.MODULE$);
                    return genericTarget;
                }
                default: {
                    throw new Target.NamedException(new StringBuilder(27).append("Cannot deserialize Target: ").append(s).toString());
                }
            }
        })).tryToComplete();
    }

    public ModuleTarget referringModule(IsMember a) {
        ModuleTarget moduleTarget;
        IsMember isMember = a;
        if (isMember instanceof ModuleTarget) {
            ModuleTarget moduleTarget2;
            moduleTarget = moduleTarget2 = (ModuleTarget)isMember;
        } else if (isMember instanceof InstanceTarget) {
            InstanceTarget instanceTarget = (InstanceTarget)isMember;
            moduleTarget = instanceTarget.ofModuleTarget();
        } else if (isMember instanceof ReferenceTarget) {
            ReferenceTarget referenceTarget = (ReferenceTarget)isMember;
            moduleTarget = referenceTarget.pathlessTarget().moduleTarget();
        } else {
            throw new MatchError(isMember);
        }
        return moduleTarget;
    }

    public Target getPathlessTarget(Target t) {
        GenericTarget genericTarget;
        Target target;
        Target target2 = t.tryToComplete();
        if (target2 instanceof CircuitTarget) {
            CircuitTarget circuitTarget;
            target = circuitTarget = (CircuitTarget)target2;
        } else if (target2 instanceof IsMember) {
            IsMember isMember = (IsMember)target2;
            target = isMember.pathlessTarget();
        } else if (target2 instanceof GenericTarget && (genericTarget = (GenericTarget)target2).isLegal()) {
            Vector newTokens = (Vector)((AbstractIterable)((Object)genericTarget.tokens())).dropWhile((Function1<TargetToken, Object> & Serializable)x -> BoxesRunTime.boxToBoolean(Target$.$anonfun$getPathlessTarget$1(x)));
            target = new GenericTarget(genericTarget.circuitOpt(), genericTarget.moduleOpt(), newTokens);
        } else {
            throw scala.sys.package$.MODULE$.error(new StringBuilder(21).append("Can't make ").append(target2).append(" pathless!").toString());
        }
        return target;
    }

    public Target getReferenceTarget(Target t) {
        GenericTarget genericTarget;
        GenericTarget genericTarget2 = t.toGenericTarget();
        if (genericTarget2 == null || !(genericTarget = genericTarget2).isLegal()) {
            throw scala.sys.package$.MODULE$.error(new StringBuilder(21).append("Can't make ").append(genericTarget2).append(" pathless!").toString());
        }
        Vector newTokens = (Vector)((IndexedSeqOps)((IterableOps)((Vector)genericTarget.tokens()).reverse()).dropWhile((Function1<TargetToken, Object> & Serializable)x0$1 -> BoxesRunTime.boxToBoolean(Target$.$anonfun$getReferenceTarget$1(x0$1)))).reverse();
        GenericTarget genericTarget3 = new GenericTarget(genericTarget.circuitOpt(), genericTarget.moduleOpt(), newTokens);
        return genericTarget3.tryToComplete();
    }

    public static final /* synthetic */ boolean $anonfun$isOnly$2(boolean x$2, boolean x$3) {
        return x$2 || x$3;
    }

    public static final /* synthetic */ boolean $anonfun$getPathlessTarget$1(TargetToken x) {
        return x instanceof TargetToken.Instance || x instanceof TargetToken.OfModule;
    }

    public static final /* synthetic */ boolean $anonfun$getReferenceTarget$1(TargetToken x0$1) {
        TargetToken targetToken = x0$1;
        boolean bl = targetToken instanceof TargetToken.Field ? true : (targetToken instanceof TargetToken.Index ? true : (TargetToken$Clock$.MODULE$.equals(targetToken) ? true : (TargetToken$Init$.MODULE$.equals(targetToken) ? true : TargetToken$Reset$.MODULE$.equals(targetToken))));
        return bl;
    }

    private Target$() {
    }
}

