﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/sso-admin/SSOAdminRequest.h>
#include <aws/sso-admin/SSOAdmin_EXPORTS.h>

#include <utility>

namespace Aws {
namespace SSOAdmin {
namespace Model {

/**
 */
class DetachManagedPolicyFromPermissionSetRequest : public SSOAdminRequest {
 public:
  AWS_SSOADMIN_API DetachManagedPolicyFromPermissionSetRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DetachManagedPolicyFromPermissionSet"; }

  AWS_SSOADMIN_API Aws::String SerializePayload() const override;

  AWS_SSOADMIN_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;

  ///@{
  /**
   * <p>The ARN of the IAM Identity Center instance under which the operation will be
   * executed. For more information about ARNs, see <a
   * href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
   * (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web
   * Services General Reference</i>.</p>
   */
  inline const Aws::String& GetInstanceArn() const { return m_instanceArn; }
  inline bool InstanceArnHasBeenSet() const { return m_instanceArnHasBeenSet; }
  template <typename InstanceArnT = Aws::String>
  void SetInstanceArn(InstanceArnT&& value) {
    m_instanceArnHasBeenSet = true;
    m_instanceArn = std::forward<InstanceArnT>(value);
  }
  template <typename InstanceArnT = Aws::String>
  DetachManagedPolicyFromPermissionSetRequest& WithInstanceArn(InstanceArnT&& value) {
    SetInstanceArn(std::forward<InstanceArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ARN of the <a>PermissionSet</a> from which the policy should be
   * detached.</p>
   */
  inline const Aws::String& GetPermissionSetArn() const { return m_permissionSetArn; }
  inline bool PermissionSetArnHasBeenSet() const { return m_permissionSetArnHasBeenSet; }
  template <typename PermissionSetArnT = Aws::String>
  void SetPermissionSetArn(PermissionSetArnT&& value) {
    m_permissionSetArnHasBeenSet = true;
    m_permissionSetArn = std::forward<PermissionSetArnT>(value);
  }
  template <typename PermissionSetArnT = Aws::String>
  DetachManagedPolicyFromPermissionSetRequest& WithPermissionSetArn(PermissionSetArnT&& value) {
    SetPermissionSetArn(std::forward<PermissionSetArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Web Services managed policy ARN to be detached from a permission
   * set.</p>
   */
  inline const Aws::String& GetManagedPolicyArn() const { return m_managedPolicyArn; }
  inline bool ManagedPolicyArnHasBeenSet() const { return m_managedPolicyArnHasBeenSet; }
  template <typename ManagedPolicyArnT = Aws::String>
  void SetManagedPolicyArn(ManagedPolicyArnT&& value) {
    m_managedPolicyArnHasBeenSet = true;
    m_managedPolicyArn = std::forward<ManagedPolicyArnT>(value);
  }
  template <typename ManagedPolicyArnT = Aws::String>
  DetachManagedPolicyFromPermissionSetRequest& WithManagedPolicyArn(ManagedPolicyArnT&& value) {
    SetManagedPolicyArn(std::forward<ManagedPolicyArnT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_instanceArn;
  bool m_instanceArnHasBeenSet = false;

  Aws::String m_permissionSetArn;
  bool m_permissionSetArnHasBeenSet = false;

  Aws::String m_managedPolicyArn;
  bool m_managedPolicyArnHasBeenSet = false;
};

}  // namespace Model
}  // namespace SSOAdmin
}  // namespace Aws
