/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.mutating.CellMutation;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.datagrid.mutating.RowMutation;
import com.intellij.database.settings.DataGridSettings;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.testFramework.LightVirtualFileBase;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import com.intellij.util.containers.ContainerUtil;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridUtilCore {
    public static final String FAILED_TO_LOAD_PREFIX = "<failed to load>";
    public static final String COLUMN_NAME_PREFIX = "column ";
    public static final String OPEN_FILE_DESC = "Open file";

    protected GridUtilCore() {
    }

    @Contract(value="null,_->null;!null,_->_")
    public static <R, C, T extends GridDataHookUp<R, C>> T getHookUp(@Nullable CoreGrid<R, C> grid, Class<T> clazz) {
        GridDataHookUp<R, C> hookup = grid != null ? grid.getDataHookup() : null;
        return (T)((GridDataHookUp)ObjectUtils.tryCast(hookup, clazz));
    }

    @NotNull
    public static List<RowMutation> mergeAll(@NotNull List<? extends CellMutation> mutations, @NotNull GridModel<GridRow, GridColumn> model) {
        if (mutations == null) {
            GridUtilCore.$$$reportNull$$$0(0);
        }
        if (model == null) {
            GridUtilCore.$$$reportNull$$$0(1);
        }
        ArrayList<? extends CellMutation> copy = new ArrayList<CellMutation>(mutations);
        ArrayList<RowMutation> rowMutations = new ArrayList<RowMutation>();
        while (!copy.isEmpty()) {
            rowMutations.add(GridUtilCore.merge(copy, model));
        }
        List<RowMutation> list = rowMutations.stream().filter(Objects::nonNull).sorted().collect(Collectors.toList());
        if (list == null) {
            GridUtilCore.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Nullable
    private static RowMutation merge(@NotNull List<? extends CellMutation> mutations, @NotNull GridModel<GridRow, GridColumn> model) {
        CellMutation item;
        if (mutations == null) {
            GridUtilCore.$$$reportNull$$$0(3);
        }
        if (model == null) {
            GridUtilCore.$$$reportNull$$$0(4);
        }
        if ((item = (CellMutation)ContainerUtil.getFirstItem(mutations)) == null) {
            throw new IllegalStateException("Shouldn't call merge() when there is no pending changes");
        }
        mutations.remove(item);
        List toMerge = ContainerUtil.filter(mutations, item::canMergeByRowWith);
        mutations.removeAll(toMerge);
        RowMutation merged = item.createRowMutation(model);
        for (CellMutation mutation : toMerge) {
            if (merged == null) {
                merged = mutation.createRowMutation(model);
                continue;
            }
            merged = merged.merge(mutation.createRowMutation(model));
        }
        return merged;
    }

    @NotNull
    public static List<CellMutation> createMutations(@NotNull ModelIndexSet<GridRow> rows, @NotNull ModelIndexSet<GridColumn> columns, @Nullable Object value) {
        if (rows == null) {
            GridUtilCore.$$$reportNull$$$0(5);
        }
        if (columns == null) {
            GridUtilCore.$$$reportNull$$$0(6);
        }
        ArrayList<CellMutation> mutations = new ArrayList<CellMutation>();
        for (ModelIndex rowIdx : rows.asIterable()) {
            for (ModelIndex columnIdx : columns.asIterable()) {
                mutations.add(new CellMutation(rowIdx, columnIdx, value));
            }
        }
        ArrayList<CellMutation> arrayList = mutations;
        if (arrayList == null) {
            GridUtilCore.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @NotNull
    public static <R extends GridRow, C extends GridColumn> ModelIndex<C> findColumn(@NotNull GridModel<R, C> gridModel, @Nullable String name, boolean caseSensitive) {
        if (gridModel == null) {
            GridUtilCore.$$$reportNull$$$0(8);
        }
        for (ModelIndex c : gridModel.getColumnIndices().asIterable()) {
            GridColumn column = (GridColumn)gridModel.getColumn(c);
            if (column == null || !Comparing.strEqual((String)name, (String)column.getName(), (boolean)caseSensitive)) continue;
            ModelIndex modelIndex = c;
            if (modelIndex == null) {
                GridUtilCore.$$$reportNull$$$0(9);
            }
            return modelIndex;
        }
        ModelIndex<C> modelIndex = ModelIndex.forColumn(gridModel, -1);
        if (modelIndex == null) {
            GridUtilCore.$$$reportNull$$$0(10);
        }
        return modelIndex;
    }

    public static String generateColumnName(@NotNull GridModel<? extends GridRow, ? extends GridColumn> model) {
        if (model == null) {
            GridUtilCore.$$$reportNull$$$0(11);
        }
        int idx = model.getColumnCount() + 1;
        String name = COLUMN_NAME_PREFIX + idx;
        while (GridUtilCore.findColumn(model, name, false).asInteger() != -1) {
            name = COLUMN_NAME_PREFIX + ++idx;
        }
        return name;
    }

    public static boolean isRowId(@Nullable GridColumn column) {
        return column != null && column.getAttributes().contains((Object)ColumnDescriptor.Attribute.ROW_ID);
    }

    public static boolean isVirtualColumn(@Nullable GridColumn column) {
        return column != null && column.getAttributes().contains((Object)ColumnDescriptor.Attribute.VIRTUAL);
    }

    @NlsSafe
    @NotNull
    public static String getLongMessage(@NotNull Throwable e) {
        if (e == null) {
            GridUtilCore.$$$reportNull$$$0(12);
        }
        String string = GridUtilCore.getMessagePrefix(e) + GridUtilCore.getMessage(e);
        if (string == null) {
            GridUtilCore.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NlsSafe
    @NotNull
    public static String getMessage(@NotNull Throwable t) {
        String m;
        if (t == null) {
            GridUtilCore.$$$reportNull$$$0(14);
        }
        String string = StringUtil.isNotEmpty((String)(m = t.getMessage())) ? m.trim() : t.getClass().getName();
        if (string == null) {
            GridUtilCore.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    public static String getMessagePrefix(@NotNull Throwable t) {
        if (t == null) {
            GridUtilCore.$$$reportNull$$$0(16);
        }
        if (GridUtilCore.isUserOutput(t)) {
            return "";
        }
        if (!(t instanceof SQLException)) {
            return "";
        }
        SQLException e = (SQLException)t;
        String state = e.getSQLState();
        int code = e.getErrorCode();
        if (StringUtil.isEmpty((String)state)) {
            return code != 0 ? "[" + code + "] " : "";
        }
        if (code != 0) {
            String string = "[" + state + "][" + code + "] ";
            if (string == null) {
                GridUtilCore.$$$reportNull$$$0(17);
            }
            return string;
        }
        if (!GridUtilCore.isZeroState(state)) {
            String string = "[" + state + "] ";
            if (string == null) {
                GridUtilCore.$$$reportNull$$$0(18);
            }
            return string;
        }
        return "";
    }

    private static boolean isZeroState(@Nullable String state) {
        return "0".equals(state) || "00000".equals(state) || "S0000".equals(state);
    }

    public static boolean isUserOutput(@NotNull Throwable t) {
        if (t == null) {
            GridUtilCore.$$$reportNull$$$0(19);
        }
        return t instanceof SQLWarning && ((SQLWarning)t).getErrorCode() == 0 && GridUtilCore.isUserOutputState(((SQLWarning)t).getSQLState());
    }

    private static boolean isUserOutputState(@Nullable String state) {
        return StringUtil.isEmpty((String)state) || GridUtilCore.isZeroState(state) || "S0001".equals(state);
    }

    public static boolean isPageSizeUnlimited(int pageSize) {
        return pageSize < 1;
    }

    public static int getPageSize(@Nullable DataGridSettings settings) {
        return settings == null ? 500 : (settings.isLimitPageSize() ? settings.getPageSize() : -1);
    }

    @NlsSafe
    @NotNull
    public static String wrapInOpenFileLink(@NotNull String path) {
        if (path == null) {
            GridUtilCore.$$$reportNull$$$0(20);
        }
        String string = "<a href=\"Open file\">" + PathUtil.getFileName((String)path) + "</a>";
        if (string == null) {
            GridUtilCore.$$$reportNull$$$0(21);
        }
        return string;
    }

    @RequiresWriteLock
    public static void associatePsiSafe(@NotNull Document document, @NotNull PsiFile psiFile) {
        VirtualFile oldFile;
        if (document == null) {
            GridUtilCore.$$$reportNull$$$0(22);
        }
        if (psiFile == null) {
            GridUtilCore.$$$reportNull$$$0(23);
        }
        if ((oldFile = FileDocumentManager.getInstance().getFile(document)) instanceof LightVirtualFileBase) {
            LightVirtualFileBase lf = (LightVirtualFileBase)oldFile;
            lf.setValid(false);
        }
        ((PsiDocumentManagerBase)PsiDocumentManager.getInstance((Project)psiFile.getProject())).associatePsi(document, psiFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 7, 9, 10, 13, 15, 17, 18, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mutations";
                break;
            }
            case 1: 
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/GridUtilCore";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rows";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gridModel";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 14: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/GridUtilCore";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeAll";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createMutations";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findColumn";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getLongMessage";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessage";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessagePrefix";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapInOpenFileLink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "mergeAll";
                break;
            }
            case 2: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 21: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createMutations";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findColumn";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "generateColumnName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getLongMessage";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getMessage";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getMessagePrefix";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isUserOutput";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "wrapInOpenFileLink";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "associatePsiSafe";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 7, 9, 10, 13, 15, 17, 18, 21 -> new IllegalStateException(string);
        };
    }
}

