/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.java.dependencyView;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.intellij.util.io.AppendablePersistentMap;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.function.ObjIntConsumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.java.dependencyView.IntObjectMultiMaplet;
import org.jetbrains.jps.builders.storage.BuildDataCorruptedException;

final class IntObjectPersistentMultiMaplet<V>
extends IntObjectMultiMaplet<V> {
    private static final Collection<?> NULL_COLLECTION = Collections.emptySet();
    private static final int CACHE_SIZE = 256;
    private final PersistentHashMap<Integer, Collection<V>> map;
    private final DataExternalizer<V> valueExternalizer;
    private final LoadingCache<Integer, Collection<V>> cache;

    IntObjectPersistentMultiMaplet(File file, KeyDescriptor<Integer> keyExternalizer, DataExternalizer<V> valueExternalizer, Supplier<? extends Collection<V>> collectionFactory) throws IOException {
        this.valueExternalizer = valueExternalizer;
        this.map = new PersistentHashMap(file.toPath(), keyExternalizer, new CollectionDataExternalizer<V>(valueExternalizer, collectionFactory));
        this.cache = Caffeine.newBuilder().maximumSize(256L).build(key -> {
            try {
                Collection collection = (Collection)this.map.get(key);
                return collection == null ? NULL_COLLECTION : collection;
            }
            catch (IOException e) {
                throw new BuildDataCorruptedException(e);
            }
        });
    }

    @Override
    public boolean containsKey(int key) {
        try {
            return this.map.containsMapping((Object)key);
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public Collection<V> get(int key) {
        Collection collection = (Collection)this.cache.get((Object)key);
        return collection == NULL_COLLECTION ? null : collection;
    }

    @Override
    public void replace(int key, Collection<V> value) {
        try {
            this.cache.invalidate((Object)key);
            if (value == null || value.isEmpty()) {
                this.map.remove((Object)key);
            } else {
                this.map.put((Object)key, value);
            }
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public void put(int key, final Collection<V> value) {
        try {
            this.cache.invalidate((Object)key);
            this.map.appendData((Object)key, new AppendablePersistentMap.ValueDataAppender(){

                public void append(@NotNull DataOutput out) throws IOException {
                    if (out == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    for (Object v : value) {
                        IntObjectPersistentMultiMaplet.this.valueExternalizer.save(out, v);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "org/jetbrains/jps/builders/java/dependencyView/IntObjectPersistentMultiMaplet$1", "append"));
                }
            });
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public void put(int key, V value) {
        this.put(key, (V)Collections.singleton(value));
    }

    @Override
    public void removeAll(int key, Collection<V> values) {
        try {
            Collection collection;
            if (!values.isEmpty() && (collection = (Collection)this.cache.get((Object)key)) != NULL_COLLECTION && collection.removeAll(values)) {
                this.cache.invalidate((Object)key);
                if (collection.isEmpty()) {
                    this.map.remove((Object)key);
                } else {
                    this.map.put((Object)key, (Object)collection);
                }
            }
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public void removeFrom(int key, V value) {
        try {
            Collection collection = (Collection)this.cache.get((Object)key);
            if (collection != NULL_COLLECTION && collection.remove(value)) {
                this.cache.invalidate((Object)key);
                if (collection.isEmpty()) {
                    this.map.remove((Object)key);
                } else {
                    this.map.put((Object)key, (Object)collection);
                }
            }
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public void remove(int key) {
        try {
            this.cache.invalidate((Object)key);
            this.map.remove((Object)key);
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public void putAll(IntObjectMultiMaplet<V> m) {
        m.forEachEntry((vs, value) -> this.put(value, (V)vs));
    }

    @Override
    public void replaceAll(IntObjectMultiMaplet<V> m) {
        m.forEachEntry((vs, value) -> this.replace(value, (Collection<V>)vs));
    }

    @Override
    public void close() {
        try {
            this.cache.invalidateAll();
            this.map.close();
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public void flush(boolean memoryCachesOnly) {
        if (memoryCachesOnly) {
            if (this.map.isDirty()) {
                this.map.dropMemoryCaches();
            }
        } else {
            this.map.force();
        }
    }

    @Override
    void forEachEntry(ObjIntConsumer<? super Collection<V>> procedure) {
        try {
            this.map.processKeysWithExistingMapping(key -> {
                try {
                    procedure.accept((Collection<V>)this.map.get(key), (int)key);
                }
                catch (IOException e) {
                    throw new BuildDataCorruptedException(e);
                }
                return true;
            });
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    private static final class CollectionDataExternalizer<V>
    implements DataExternalizer<Collection<V>> {
        private final DataExternalizer<V> myElementExternalizer;
        private final Supplier<? extends Collection<V>> myCollectionFactory;

        CollectionDataExternalizer(DataExternalizer<V> elementExternalizer, Supplier<? extends Collection<V>> collectionFactory) {
            this.myElementExternalizer = elementExternalizer;
            this.myCollectionFactory = collectionFactory;
        }

        public void save(@NotNull DataOutput out, Collection<V> value) throws IOException {
            if (out == null) {
                CollectionDataExternalizer.$$$reportNull$$$0(0);
            }
            for (V x : value) {
                this.myElementExternalizer.save(out, x);
            }
        }

        public Collection<V> read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                CollectionDataExternalizer.$$$reportNull$$$0(1);
            }
            Collection<V> result = this.myCollectionFactory.get();
            DataInputStream stream = (DataInputStream)in;
            while (stream.available() > 0) {
                result.add(this.myElementExternalizer.read(in));
            }
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/jps/builders/java/dependencyView/IntObjectPersistentMultiMaplet$CollectionDataExternalizer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

