/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.BranchChangeListener;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import git4idea.GitUtil;
import git4idea.branch.GitBranchUiHandler;
import git4idea.changes.GitChangeUtils;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitMessageWithFilesDetector;
import git4idea.config.GitVcsSettings;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class GitBranchOperation {
    protected static final Logger LOG = Logger.getInstance(GitBranchOperation.class);
    @NotNull
    protected final Project myProject;
    @NotNull
    protected final Git myGit;
    @NotNull
    protected final GitBranchUiHandler myUiHandler;
    @NotNull
    private final Collection<GitRepository> myRepositories;
    @NotNull
    protected final Map<GitRepository, String> myCurrentHeads;
    @NotNull
    protected final Map<GitRepository, String> myInitialRevisions;
    @NotNull
    private final GitVcsSettings mySettings;
    @NotNull
    private final Collection<GitRepository> mySuccessfulRepositories;
    @NotNull
    private final Collection<GitRepository> mySkippedRepositories;
    @NotNull
    private final Collection<GitRepository> myRemainingRepositories;

    protected GitBranchOperation(@NotNull Project project, @NotNull Git git, @NotNull GitBranchUiHandler uiHandler, @NotNull Collection<? extends GitRepository> repositories) {
        if (project == null) {
            GitBranchOperation.$$$reportNull$$$0(0);
        }
        if (git == null) {
            GitBranchOperation.$$$reportNull$$$0(1);
        }
        if (uiHandler == null) {
            GitBranchOperation.$$$reportNull$$$0(2);
        }
        if (repositories == null) {
            GitBranchOperation.$$$reportNull$$$0(3);
        }
        this.myProject = project;
        this.myGit = git;
        this.myUiHandler = uiHandler;
        this.myRepositories = GitUtil.getRepositoryManager(project).sortByDependency(repositories);
        this.myCurrentHeads = ContainerUtil.newMapFromKeys(repositories.iterator(), repo -> (String)ObjectUtils.chooseNotNull((Object)repo.getCurrentBranchName(), (Object)repo.getCurrentRevision()));
        this.myInitialRevisions = ContainerUtil.newMapFromKeys(repositories.iterator(), Repository::getCurrentRevision);
        this.mySuccessfulRepositories = new ArrayList<GitRepository>();
        this.mySkippedRepositories = new ArrayList<GitRepository>();
        this.myRemainingRepositories = new ArrayList<GitRepository>(this.myRepositories);
        this.mySettings = GitVcsSettings.getInstance(this.myProject);
    }

    protected abstract void execute();

    protected abstract void rollback();

    @NlsContexts.NotificationContent
    @NotNull
    protected abstract String getSuccessMessage();

    @NotNull
    @Nls(capitalization=Nls.Capitalization.Sentence)
    protected abstract String getRollbackProposal();

    @NotNull
    @Nls
    protected abstract String getOperationName();

    @NotNull
    protected final GitRepository next() {
        GitRepository gitRepository = this.myRemainingRepositories.iterator().next();
        if (gitRepository == null) {
            GitBranchOperation.$$$reportNull$$$0(4);
        }
        return gitRepository;
    }

    protected final boolean hasMoreRepositories() {
        return !this.myRemainingRepositories.isEmpty();
    }

    protected final void markSuccessful(GitRepository ... repositories) {
        for (GitRepository repository2 : repositories) {
            this.mySuccessfulRepositories.add(repository2);
            this.myRemainingRepositories.remove(repository2);
        }
    }

    protected final void markSkip(GitRepository ... repositories) {
        for (GitRepository repository2 : repositories) {
            this.mySkippedRepositories.add(repository2);
            this.myRemainingRepositories.remove(repository2);
        }
    }

    protected final boolean wereSuccessful() {
        return !this.mySuccessfulRepositories.isEmpty();
    }

    protected final boolean wereSkipped() {
        return !this.mySkippedRepositories.isEmpty();
    }

    @NotNull
    protected final Collection<GitRepository> getSuccessfulRepositories() {
        Collection<GitRepository> collection = this.mySuccessfulRepositories;
        if (collection == null) {
            GitBranchOperation.$$$reportNull$$$0(5);
        }
        return collection;
    }

    @NotNull
    protected final Collection<GitRepository> getSkippedRepositories() {
        Collection<GitRepository> collection = this.mySkippedRepositories;
        if (collection == null) {
            GitBranchOperation.$$$reportNull$$$0(6);
        }
        return collection;
    }

    @NotNull
    @NlsSafe
    protected final String successfulRepositoriesJoined() {
        String string = GitUtil.joinToHtml(this.mySuccessfulRepositories);
        if (string == null) {
            GitBranchOperation.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    protected final Collection<GitRepository> getRepositories() {
        Collection<GitRepository> collection = this.myRepositories;
        if (collection == null) {
            GitBranchOperation.$$$reportNull$$$0(8);
        }
        return collection;
    }

    @NotNull
    protected final List<GitRepository> getRemainingRepositoriesExceptGiven(@NotNull GitRepository currentRepository) {
        if (currentRepository == null) {
            GitBranchOperation.$$$reportNull$$$0(9);
        }
        ArrayList<GitRepository> repositories = new ArrayList<GitRepository>(this.myRemainingRepositories);
        repositories.remove(currentRepository);
        ArrayList<GitRepository> arrayList = repositories;
        if (arrayList == null) {
            GitBranchOperation.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    protected void notifySuccess(@NlsContexts.NotificationContent @NotNull String message) {
        if (message == null) {
            GitBranchOperation.$$$reportNull$$$0(11);
        }
        VcsNotifier.getInstance((Project)this.myProject).notifySuccess("git.branch.operation.success", "", message);
    }

    protected void notifySuccess() {
        this.notifySuccess(this.getSuccessMessage());
    }

    protected static void saveAllDocuments() {
        ApplicationManager.getApplication().invokeAndWait(() -> FileDocumentManager.getInstance().saveAllDocuments());
    }

    protected final void fatalError(@NlsContexts.NotificationTitle @NotNull String title, @NlsContexts.NotificationContent @NotNull String message) {
        if (title == null) {
            GitBranchOperation.$$$reportNull$$$0(12);
        }
        if (message == null) {
            GitBranchOperation.$$$reportNull$$$0(13);
        }
        if (this.wereSuccessful()) {
            this.showFatalErrorDialogWithRollback(title, message);
        } else {
            this.notifyError(title, message);
        }
    }

    protected final void fatalError(@NlsContexts.NotificationTitle @NotNull String title, @NotNull GitCommandResult result2) {
        if (title == null) {
            GitBranchOperation.$$$reportNull$$$0(14);
        }
        if (result2 == null) {
            GitBranchOperation.$$$reportNull$$$0(15);
        }
        this.fatalError(title, result2.getErrorOutputAsHtmlString());
    }

    protected final void showFatalErrorDialogWithRollback(@NlsContexts.DialogTitle @NotNull String title, @NlsContexts.DialogMessage @NotNull String message) {
        boolean rollback;
        if (title == null) {
            GitBranchOperation.$$$reportNull$$$0(16);
        }
        if (message == null) {
            GitBranchOperation.$$$reportNull$$$0(17);
        }
        if (rollback = this.myUiHandler.notifyErrorWithRollbackProposal(title, message, this.getRollbackProposal())) {
            this.rollback();
        }
    }

    protected final void notifyError(@NlsContexts.NotificationTitle @NotNull String title, @NlsContexts.NotificationContent @NotNull String message) {
        if (title == null) {
            GitBranchOperation.$$$reportNull$$$0(18);
        }
        if (message == null) {
            GitBranchOperation.$$$reportNull$$$0(19);
        }
        this.myUiHandler.notifyError(title, message);
    }

    @NotNull
    protected final ProgressIndicator getIndicator() {
        ProgressIndicator progressIndicator = this.myUiHandler.getProgressIndicator();
        if (progressIndicator == null) {
            GitBranchOperation.$$$reportNull$$$0(20);
        }
        return progressIndicator;
    }

    protected final void fatalUnmergedFilesError() {
        if (this.wereSuccessful()) {
            this.showUnmergedFilesDialogWithRollback();
        } else {
            this.showUnmergedFilesNotification();
        }
    }

    protected final void updateRecentBranch() {
        if (this.getRepositories().size() == 1) {
            GitRepository repository2 = this.myRepositories.iterator().next();
            String currentHead = this.myCurrentHeads.get(repository2);
            if (currentHead != null) {
                this.mySettings.setRecentBranchOfRepository(repository2.getRoot().getPath(), currentHead);
            } else {
                LOG.error("Current head is not known for " + repository2.getRoot().getPath());
            }
        } else {
            String recentCommonBranch = this.getRecentCommonBranch();
            if (recentCommonBranch != null) {
                this.mySettings.setRecentCommonBranch(recentCommonBranch);
            }
        }
    }

    protected final void notifyBranchWillChange() {
        String currentBranch = (String)ContainerUtil.getFirstItem(this.myCurrentHeads.values());
        if (currentBranch != null) {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (this.myProject.isDisposed()) {
                    return;
                }
                ((BranchChangeListener)this.myProject.getMessageBus().syncPublisher(BranchChangeListener.VCS_BRANCH_CHANGED)).branchWillChange(currentBranch);
            });
        }
    }

    protected final void notifyBranchHasChanged(@Nullable String branchName) {
        if (branchName != null) {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (this.myProject.isDisposed()) {
                    return;
                }
                ((BranchChangeListener)this.myProject.getMessageBus().syncPublisher(BranchChangeListener.VCS_BRANCH_CHANGED)).branchHasChanged(branchName);
            });
        }
    }

    @NotNull
    protected final String getInitialRevision(@NotNull GitRepository repository2) {
        if (repository2 == null) {
            GitBranchOperation.$$$reportNull$$$0(21);
        }
        String string = this.myInitialRevisions.get(repository2);
        if (string == null) {
            GitBranchOperation.$$$reportNull$$$0(22);
        }
        return string;
    }

    @Nullable
    private String getRecentCommonBranch() {
        String recentCommonBranch = null;
        for (String branch : this.myCurrentHeads.values()) {
            if (recentCommonBranch == null) {
                recentCommonBranch = branch;
                continue;
            }
            if (recentCommonBranch.equals(branch)) continue;
            return null;
        }
        return recentCommonBranch;
    }

    private void showUnmergedFilesDialogWithRollback() {
        boolean ok = this.myUiHandler.showUnmergedFilesMessageWithRollback(this.getOperationName(), this.getRollbackProposal());
        if (ok) {
            this.rollback();
        }
    }

    private void showUnmergedFilesNotification() {
        this.myUiHandler.showUnmergedFilesNotification(this.getOperationName(), this.getRepositories());
    }

    protected final void fatalLocalChangesError(@NotNull String reference) {
        if (reference == null) {
            GitBranchOperation.$$$reportNull$$$0(23);
        }
        String title = GitBundle.message("branch.operation.could.not.0.operation.name.1.reference", this.getOperationName(), reference);
        if (this.wereSuccessful()) {
            this.showFatalErrorDialogWithRollback(title, "");
        }
    }

    protected final void fatalUntrackedFilesError(@NotNull VirtualFile root, @NotNull Collection<String> relativePaths) {
        if (root == null) {
            GitBranchOperation.$$$reportNull$$$0(24);
        }
        if (relativePaths == null) {
            GitBranchOperation.$$$reportNull$$$0(25);
        }
        String operationName = this.getOperationName();
        if (this.wereSuccessful()) {
            boolean ok = this.myUiHandler.showUntrackedFilesDialogWithRollback(operationName, this.getRollbackProposal(), root, relativePaths);
            if (ok) {
                this.rollback();
            }
        } else {
            this.myUiHandler.showUntrackedFilesNotification(operationName, root, relativePaths);
        }
    }

    @NotNull
    private Map<GitRepository, List<Change>> collectLocalChangesConflictingWithBranch(@NotNull Collection<? extends GitRepository> repositories, @NotNull String otherBranch) {
        if (repositories == null) {
            GitBranchOperation.$$$reportNull$$$0(26);
        }
        if (otherBranch == null) {
            GitBranchOperation.$$$reportNull$$$0(27);
        }
        HashMap<GitRepository, List<Change>> changes = new HashMap<GitRepository, List<Change>>();
        for (GitRepository gitRepository : repositories) {
            Collection<Change> diffWithWorkingTree = GitChangeUtils.getDiffWithWorkingTree(gitRepository, otherBranch, false);
            if (diffWithWorkingTree == null) continue;
            List diff = ChangesUtil.iteratePaths(diffWithWorkingTree).map(FilePath::getPath).toList();
            List<Change> changesInRepo = GitUtil.findLocalChangesForPaths(this.myProject, gitRepository.getRoot(), diff, false);
            if (changesInRepo.isEmpty()) continue;
            changes.put(gitRepository, changesInRepo);
        }
        HashMap<GitRepository, List<Change>> hashMap = changes;
        if (hashMap == null) {
            GitBranchOperation.$$$reportNull$$$0(28);
        }
        return hashMap;
    }

    @NotNull
    protected final Pair<List<GitRepository>, List<Change>> getConflictingRepositoriesAndAffectedChanges(@NotNull GitRepository currentRepository, @NotNull GitMessageWithFilesDetector localChangesOverwrittenBy, String currentBranch, String nextBranch) {
        if (currentRepository == null) {
            GitBranchOperation.$$$reportNull$$$0(29);
        }
        if (localChangesOverwrittenBy == null) {
            GitBranchOperation.$$$reportNull$$$0(30);
        }
        List<Change> affectedChanges = GitUtil.findLocalChangesForPaths(this.myProject, currentRepository.getRoot(), localChangesOverwrittenBy.getRelativeFilePaths(), true);
        Map<GitRepository, List<Change>> conflictingChangesInRepositories = this.collectLocalChangesConflictingWithBranch(this.getRemainingRepositoriesExceptGiven(currentRepository), nextBranch);
        Set<GitRepository> otherProblematicRepositories = conflictingChangesInRepositories.keySet();
        ArrayList<GitRepository> allConflictingRepositories = new ArrayList<GitRepository>(otherProblematicRepositories);
        allConflictingRepositories.add(currentRepository);
        for (List<Change> changes : conflictingChangesInRepositories.values()) {
            affectedChanges.addAll(changes);
        }
        Pair pair = Pair.create(allConflictingRepositories, affectedChanges);
        if (pair == null) {
            GitBranchOperation.$$$reportNull$$$0(31);
        }
        return pair;
    }

    @NotNull
    protected static String stringifyBranchesByRepos(@NotNull Map<GitRepository, String> heads) {
        MultiMap<String, VirtualFile> grouped;
        if (heads == null) {
            GitBranchOperation.$$$reportNull$$$0(32);
        }
        if ((grouped = GitBranchOperation.groupByBranches(heads)).size() == 1) {
            String string = (String)grouped.keySet().iterator().next();
            if (string == null) {
                GitBranchOperation.$$$reportNull$$$0(33);
            }
            return string;
        }
        String string = StringUtil.join((Collection)grouped.entrySet(), entry -> {
            String roots = StringUtil.join((Collection)((Collection)entry.getValue()), file -> file.getName(), (String)", ");
            return GitBundle.message("branch.operation.in", entry.getKey(), roots);
        }, (String)"<br/>");
        if (string == null) {
            GitBranchOperation.$$$reportNull$$$0(34);
        }
        return string;
    }

    @NotNull
    private static MultiMap<String, VirtualFile> groupByBranches(@NotNull Map<GitRepository, String> heads) {
        if (heads == null) {
            GitBranchOperation.$$$reportNull$$$0(35);
        }
        MultiMap result2 = MultiMap.createLinked();
        List sortedRepos = DvcsUtil.sortRepositories(heads.keySet());
        for (GitRepository repo : sortedRepos) {
            result2.putValue((Object)heads.get(repo), (Object)repo.getRoot());
        }
        MultiMap multiMap = result2;
        if (multiMap == null) {
            GitBranchOperation.$$$reportNull$$$0(36);
        }
        return multiMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 8, 10, 20, 22, 28, 31, 33, 34, 36 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiHandler";
                break;
            }
            case 3: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 20: 
            case 22: 
            case 28: 
            case 31: 
            case 33: 
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/branch/GitBranchOperation";
                break;
            }
            case 9: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentRepository";
                break;
            }
            case 11: 
            case 13: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 12: 
            case 14: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePaths";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherBranch";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localChangesOverwrittenBy";
                break;
            }
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "heads";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/branch/GitBranchOperation";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "next";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuccessfulRepositories";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSkippedRepositories";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "successfulRepositoriesJoined";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositories";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemainingRepositoriesExceptGiven";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndicator";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitialRevision";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "collectLocalChangesConflictingWithBranch";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getConflictingRepositoriesAndAffectedChanges";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "stringifyBranchesByRepos";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "groupByBranches";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 20: 
            case 22: 
            case 28: 
            case 31: 
            case 33: 
            case 34: 
            case 36: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getRemainingRepositoriesExceptGiven";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "notifySuccess";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "fatalError";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "showFatalErrorDialogWithRollback";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "notifyError";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getInitialRevision";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "fatalLocalChangesError";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "fatalUntrackedFilesError";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "collectLocalChangesConflictingWithBranch";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getConflictingRepositoriesAndAffectedChanges";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "stringifyBranchesByRepos";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "groupByBranches";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 8, 10, 20, 22, 28, 31, 33, 34, 36 -> new IllegalStateException(string);
        };
    }
}

