﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/route53domains/Route53Domains_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Route53Domains {
namespace Model {
class ResendContactReachabilityEmailResult {
 public:
  AWS_ROUTE53DOMAINS_API ResendContactReachabilityEmailResult() = default;
  AWS_ROUTE53DOMAINS_API ResendContactReachabilityEmailResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_ROUTE53DOMAINS_API ResendContactReachabilityEmailResult& operator=(
      const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The domain name for which you requested a confirmation email.</p>
   */
  inline const Aws::String& GetDomainName() const { return m_domainName; }
  template <typename DomainNameT = Aws::String>
  void SetDomainName(DomainNameT&& value) {
    m_domainNameHasBeenSet = true;
    m_domainName = std::forward<DomainNameT>(value);
  }
  template <typename DomainNameT = Aws::String>
  ResendContactReachabilityEmailResult& WithDomainName(DomainNameT&& value) {
    SetDomainName(std::forward<DomainNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The email address for the registrant contact at the time that we sent the
   * verification email.</p>
   */
  inline const Aws::String& GetEmailAddress() const { return m_emailAddress; }
  template <typename EmailAddressT = Aws::String>
  void SetEmailAddress(EmailAddressT&& value) {
    m_emailAddressHasBeenSet = true;
    m_emailAddress = std::forward<EmailAddressT>(value);
  }
  template <typename EmailAddressT = Aws::String>
  ResendContactReachabilityEmailResult& WithEmailAddress(EmailAddressT&& value) {
    SetEmailAddress(std::forward<EmailAddressT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> <code>True</code> if the email address for the registrant contact has
   * already been verified, and <code>false</code> otherwise. If the email address
   * has already been verified, we don't send another confirmation email.</p>
   */
  inline bool GetIsAlreadyVerified() const { return m_isAlreadyVerified; }
  inline void SetIsAlreadyVerified(bool value) {
    m_isAlreadyVerifiedHasBeenSet = true;
    m_isAlreadyVerified = value;
  }
  inline ResendContactReachabilityEmailResult& WithIsAlreadyVerified(bool value) {
    SetIsAlreadyVerified(value);
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ResendContactReachabilityEmailResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_domainName;

  Aws::String m_emailAddress;

  bool m_isAlreadyVerified{false};

  Aws::String m_requestId;
  bool m_domainNameHasBeenSet = false;
  bool m_emailAddressHasBeenSet = false;
  bool m_isAlreadyVerifiedHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Route53Domains
}  // namespace Aws
