﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/logs/CloudWatchLogs_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace CloudWatchLogs {
namespace Model {

/**
 * <p>This object contains information about this Live Tail session, including the
 * log groups included and the log stream filters, if any.</p><p><h3>See Also:</h3>
 * <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/LiveTailSessionStart">AWS
 * API Reference</a></p>
 */
class LiveTailSessionStart {
 public:
  AWS_CLOUDWATCHLOGS_API LiveTailSessionStart() = default;
  AWS_CLOUDWATCHLOGS_API LiveTailSessionStart(Aws::Utils::Json::JsonView jsonValue);
  AWS_CLOUDWATCHLOGS_API LiveTailSessionStart& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_CLOUDWATCHLOGS_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The unique ID generated by CloudWatch Logs to identify this Live Tail session
   * request.</p>
   */
  inline const Aws::String& GetRequestId() const { return m_requestId; }
  inline bool RequestIdHasBeenSet() const { return m_requestIdHasBeenSet; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  LiveTailSessionStart& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The unique ID generated by CloudWatch Logs to identify this Live Tail
   * session.</p>
   */
  inline const Aws::String& GetSessionId() const { return m_sessionId; }
  inline bool SessionIdHasBeenSet() const { return m_sessionIdHasBeenSet; }
  template <typename SessionIdT = Aws::String>
  void SetSessionId(SessionIdT&& value) {
    m_sessionIdHasBeenSet = true;
    m_sessionId = std::forward<SessionIdT>(value);
  }
  template <typename SessionIdT = Aws::String>
  LiveTailSessionStart& WithSessionId(SessionIdT&& value) {
    SetSessionId(std::forward<SessionIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>An array of the names and ARNs of the log groups included in this Live Tail
   * session.</p>
   */
  inline const Aws::Vector<Aws::String>& GetLogGroupIdentifiers() const { return m_logGroupIdentifiers; }
  inline bool LogGroupIdentifiersHasBeenSet() const { return m_logGroupIdentifiersHasBeenSet; }
  template <typename LogGroupIdentifiersT = Aws::Vector<Aws::String>>
  void SetLogGroupIdentifiers(LogGroupIdentifiersT&& value) {
    m_logGroupIdentifiersHasBeenSet = true;
    m_logGroupIdentifiers = std::forward<LogGroupIdentifiersT>(value);
  }
  template <typename LogGroupIdentifiersT = Aws::Vector<Aws::String>>
  LiveTailSessionStart& WithLogGroupIdentifiers(LogGroupIdentifiersT&& value) {
    SetLogGroupIdentifiers(std::forward<LogGroupIdentifiersT>(value));
    return *this;
  }
  template <typename LogGroupIdentifiersT = Aws::String>
  LiveTailSessionStart& AddLogGroupIdentifiers(LogGroupIdentifiersT&& value) {
    m_logGroupIdentifiersHasBeenSet = true;
    m_logGroupIdentifiers.emplace_back(std::forward<LogGroupIdentifiersT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>If your StartLiveTail operation request included a
   * <code>logStreamNames</code> parameter that filtered the session to only include
   * certain log streams, these streams are listed here.</p>
   */
  inline const Aws::Vector<Aws::String>& GetLogStreamNames() const { return m_logStreamNames; }
  inline bool LogStreamNamesHasBeenSet() const { return m_logStreamNamesHasBeenSet; }
  template <typename LogStreamNamesT = Aws::Vector<Aws::String>>
  void SetLogStreamNames(LogStreamNamesT&& value) {
    m_logStreamNamesHasBeenSet = true;
    m_logStreamNames = std::forward<LogStreamNamesT>(value);
  }
  template <typename LogStreamNamesT = Aws::Vector<Aws::String>>
  LiveTailSessionStart& WithLogStreamNames(LogStreamNamesT&& value) {
    SetLogStreamNames(std::forward<LogStreamNamesT>(value));
    return *this;
  }
  template <typename LogStreamNamesT = Aws::String>
  LiveTailSessionStart& AddLogStreamNames(LogStreamNamesT&& value) {
    m_logStreamNamesHasBeenSet = true;
    m_logStreamNames.emplace_back(std::forward<LogStreamNamesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>If your StartLiveTail operation request included a
   * <code>logStreamNamePrefixes</code> parameter that filtered the session to only
   * include log streams that have names that start with certain prefixes, these
   * prefixes are listed here.</p>
   */
  inline const Aws::Vector<Aws::String>& GetLogStreamNamePrefixes() const { return m_logStreamNamePrefixes; }
  inline bool LogStreamNamePrefixesHasBeenSet() const { return m_logStreamNamePrefixesHasBeenSet; }
  template <typename LogStreamNamePrefixesT = Aws::Vector<Aws::String>>
  void SetLogStreamNamePrefixes(LogStreamNamePrefixesT&& value) {
    m_logStreamNamePrefixesHasBeenSet = true;
    m_logStreamNamePrefixes = std::forward<LogStreamNamePrefixesT>(value);
  }
  template <typename LogStreamNamePrefixesT = Aws::Vector<Aws::String>>
  LiveTailSessionStart& WithLogStreamNamePrefixes(LogStreamNamePrefixesT&& value) {
    SetLogStreamNamePrefixes(std::forward<LogStreamNamePrefixesT>(value));
    return *this;
  }
  template <typename LogStreamNamePrefixesT = Aws::String>
  LiveTailSessionStart& AddLogStreamNamePrefixes(LogStreamNamePrefixesT&& value) {
    m_logStreamNamePrefixesHasBeenSet = true;
    m_logStreamNamePrefixes.emplace_back(std::forward<LogStreamNamePrefixesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>An optional pattern to filter the results to include only log events that
   * match the pattern. For example, a filter pattern of <code>error 404</code>
   * displays only log events that include both <code>error</code> and
   * <code>404</code>.</p> <p>For more information about filter pattern syntax, see
   * <a
   * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/FilterAndPatternSyntax.html">Filter
   * and Pattern Syntax</a>.</p>
   */
  inline const Aws::String& GetLogEventFilterPattern() const { return m_logEventFilterPattern; }
  inline bool LogEventFilterPatternHasBeenSet() const { return m_logEventFilterPatternHasBeenSet; }
  template <typename LogEventFilterPatternT = Aws::String>
  void SetLogEventFilterPattern(LogEventFilterPatternT&& value) {
    m_logEventFilterPatternHasBeenSet = true;
    m_logEventFilterPattern = std::forward<LogEventFilterPatternT>(value);
  }
  template <typename LogEventFilterPatternT = Aws::String>
  LiveTailSessionStart& WithLogEventFilterPattern(LogEventFilterPatternT&& value) {
    SetLogEventFilterPattern(std::forward<LogEventFilterPatternT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_requestId;

  Aws::String m_sessionId;

  Aws::Vector<Aws::String> m_logGroupIdentifiers;

  Aws::Vector<Aws::String> m_logStreamNames;

  Aws::Vector<Aws::String> m_logStreamNamePrefixes;

  Aws::String m_logEventFilterPattern;
  bool m_requestIdHasBeenSet = false;
  bool m_sessionIdHasBeenSet = false;
  bool m_logGroupIdentifiersHasBeenSet = false;
  bool m_logStreamNamesHasBeenSet = false;
  bool m_logStreamNamePrefixesHasBeenSet = false;
  bool m_logEventFilterPatternHasBeenSet = false;
};

}  // namespace Model
}  // namespace CloudWatchLogs
}  // namespace Aws
