﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/eventbridge/EventBridge_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace EventBridge {
namespace Model {

/**
 * <p>Additional parameter included in the body. You can include up to 100
 * additional body parameters per request. An event payload cannot exceed 64
 * KB.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/ConnectionBodyParameter">AWS
 * API Reference</a></p>
 */
class ConnectionBodyParameter {
 public:
  AWS_EVENTBRIDGE_API ConnectionBodyParameter() = default;
  AWS_EVENTBRIDGE_API ConnectionBodyParameter(Aws::Utils::Json::JsonView jsonValue);
  AWS_EVENTBRIDGE_API ConnectionBodyParameter& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_EVENTBRIDGE_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The key for the parameter.</p>
   */
  inline const Aws::String& GetKey() const { return m_key; }
  inline bool KeyHasBeenSet() const { return m_keyHasBeenSet; }
  template <typename KeyT = Aws::String>
  void SetKey(KeyT&& value) {
    m_keyHasBeenSet = true;
    m_key = std::forward<KeyT>(value);
  }
  template <typename KeyT = Aws::String>
  ConnectionBodyParameter& WithKey(KeyT&& value) {
    SetKey(std::forward<KeyT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The value associated with the key.</p>
   */
  inline const Aws::String& GetValue() const { return m_value; }
  inline bool ValueHasBeenSet() const { return m_valueHasBeenSet; }
  template <typename ValueT = Aws::String>
  void SetValue(ValueT&& value) {
    m_valueHasBeenSet = true;
    m_value = std::forward<ValueT>(value);
  }
  template <typename ValueT = Aws::String>
  ConnectionBodyParameter& WithValue(ValueT&& value) {
    SetValue(std::forward<ValueT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Specifies whether the value is secret.</p>
   */
  inline bool GetIsValueSecret() const { return m_isValueSecret; }
  inline bool IsValueSecretHasBeenSet() const { return m_isValueSecretHasBeenSet; }
  inline void SetIsValueSecret(bool value) {
    m_isValueSecretHasBeenSet = true;
    m_isValueSecret = value;
  }
  inline ConnectionBodyParameter& WithIsValueSecret(bool value) {
    SetIsValueSecret(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_key;

  Aws::String m_value;

  bool m_isValueSecret{false};
  bool m_keyHasBeenSet = false;
  bool m_valueHasBeenSet = false;
  bool m_isValueSecretHasBeenSet = false;
};

}  // namespace Model
}  // namespace EventBridge
}  // namespace Aws
