/*
 * ===========================
 * VDK Visual Develeopment Kit
 * Version 1.0.4
 * December 1999
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */
#if HAVE_GNOME
#include <vdk/vdkgnomeappbar.h>
#include <vdk/forms.h>
VDKGnomeAppBar::VDKGnomeAppBar(VDKForm* owner,
			       bool has_progress,
			       bool has_status,
			       GnomePreferencesType interact):
    VDKObject(owner),
    Status("Status",this,(char*) NULL,&VDKGnomeAppBar::SetStatus),
    Default("Default",this,(char*) NULL,&VDKGnomeAppBar::SetDefault),
    Progress("Progress",this,0.0,&VDKGnomeAppBar::SetProgress,
	     &VDKGnomeAppBar::GetProgress)
{
    widget = gnome_appbar_new(has_progress,has_status,interact);
    if(has_progress)
	{
	progress = new VDKObject(owner,
	     GTK_WIDGET(gnome_appbar_get_progress(GNOME_APPBAR(widget))));
	items.add(progress);
	}
    else
	progress = NULL;
    ConnectDefaultSignals();
}		


VDKGnomeAppBar::~VDKGnomeAppBar()
{
}


#endif
