// Copyright (C) 2025 EDF
// All Rights Reserved
// This code is published under the GNU Lesser General Public License (GNU LGPL)
#ifndef GRIDADAPTBASE_H
#define GRIDADAPTBASE_H
#include <memory>
#include <vector>
#include <list>
#include <array>
#include <Eigen/Dense>

/** \file GridAdaptBase.h
 * \brief Defines an abstract grid with refinement possibility
 * \author  Pierre Gruet
 */

namespace StOpt
{
  class GridAdaptBase
  {
  public:

    // default constructor
    GridAdaptBase() : m_points()
    {}

    // constructor using points
    GridAdaptBase(const std::vector<Eigen::ArrayXd > & p_points) : m_points(p_points)
    {}

    virtual ~GridAdaptBase(){}

    /// get dimension of the grid
    virtual int getDim() const = 0;

    /// get back the number of points
    inline int getNbPoints() const { return m_points.size();}

    /// get back points
    inline  std::vector< Eigen::ArrayXd >   getPoints() const { return m_points;}

    /// get back an array with coordinates
    virtual Eigen::ArrayXd getCoord(const int & p_ipt) const = 0;

  protected:
    std::vector< Eigen::ArrayXd > m_points ; /// all points composing the grid

  };
}
#endif
