///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2018 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================
//! @examplefile reconstruction_hho.cc The hybrid high order method -- reconstruction operator
#include "rheolef.h"
using namespace rheolef;
using namespace std;
#include "sinusprod.h"
#include "diffusion_isotropic.h"
int main(int argc, char**argv) {
  environment rheolef (argc, argv);
  geo omega (argv[1]);
  string Pkd = (argc > 2) ? argv[2] : "P0",
         Pld = (argc > 3) ? argv[3] :  Pkd;
  space  Xh (omega, Pld),
         Mh (omega["sides"], Pkd);
  size_t k = Xh.degree(), l = Mh.degree(), d = omega.dimension();
  check_macro(l == k-1 || l == k || l == k+1,
    "invalid (k,l) = ("<<k<<","<<l<<")");
  space Xhs(omega, "P"+itos(k+1)+"d"),
        Zh (omega, "P0"),
        Yh = Xhs*Zh;
  trial u(Xh), lambda(Mh), x(Yh);
  test  v(Xh), mu    (Mh), y(Yh);
  auto us = x[0], zeta = x[1];
  auto vs = y[0], xi   = y[1];
  integrate_option iopt;
  iopt.invert = true;
  form inv_m  = integrate (u*v, iopt);
  form ms = integrate (lambda*mu);
  field lh = integrate(u_exact(d)*v);
  field kh = integrate(u_exact(d)*mu);
  field uh = inv_m*lh;
  field lambda_h(Mh); 
  problem pms (ms);
  pms.solve (kh, lambda_h);
  form inv_as = integrate (dot(grad_h(us),a(d)*grad_h(vs)) + us*xi
			   + vs*zeta, iopt);
  field lhs   = integrate (dot(grad_h(uh),a(d)*grad_h(vs)) + uh*xi
                    + on_local_sides((lambda_h-uh)
                                   *dot(normal(),a(d)*grad_h(vs))));
  field xh = inv_as*lhs;
  dout << catchmark("us") << xh[0];
}
