---
layout: ja
title: RD形式でのスライドの作り方
---
== RD形式でのスライドの作り方について

基本的に((<"../rd.html"/RD>))の書式を使いますが、スライド用の
RDではマークアップの使い方が通常の文書の場合と異なります。

((<"../sample/"/サンプルスライド>))にサンプルがあります。

=== ページ

一番大きな見出し「=」がページのタイトルになります。そのペー
ジは次の見出しまで続きます。

  = タイトル

  なにか

  ...

  = 次のページ

  ...

この例だと二ページになります。

=== タイトルページ

最初のページはタイトルページになります。タイトルページには見
出し付きリスト「:」でスライドのメタ情報を指定できます。

  = 発表のタイトル

  : author
     須藤功平
  : institution
     COZMIXNG

この例では、作者が須藤功平で、所属がCOZMIXNGであるということ
を示しています。

以下の属性が指定可能です:

* author

* institution

* subtitle

* content_source

* date

* start_time

* end_time

* allotted_time

  プレゼンの持ち時間です。Rabbitを起動するときに指定しなかった場合に
  使用されます。(({start_time}))と(({end_time}))を両方指定している
  場合はそれらの属性から計算されるため、(({allotted_time}))を指定する
  必要はありません。

* theme

  テーマです。Rabbitを起動するときに指定しなかった場合に使用されます。

=== 画像

verbatim blockとして記述します。

最初の行は「(({# image}))」からはじめます。「(({src = 画像のパス}))」は
必ず指定しなければいけません。以下はスライドと同じディレクトリにある
(({lavie.png}))を表示する例です。

  # image
  # src = lavie.png

「(({caption = キャプション}))」でキャプションも指定できます。

  # image
  # src = lavie.png
  # caption = Lavie

「(({relative_width = 90}))」を指定するとスライドの横幅ほとんどを使って
大きく画像を表示します。横長の画像を大きく表示するときはこの指定をする
とよいでしょう。

  # image
  # src = lavie.png
  # relative_width = 90

縦長の画像は「(({relative_height = 90}))」を指定してください。スライド
の縦幅ほとんどを使って大きく画像を表示します。

  # image
  # src = lavie.png
  # relative_height = 90

TODO: 指定できるオプションのリストを書く

=== 実体参照

inline verbatimとして記述します。詳しくはsample/rabbit.rdを見
てください。

TODO: ここに書き方を入れる。

=== 上（下）付き文字

inline verbatimとして記述します。詳しくはsample/rabbit.rdを見
てください。

TODO: ここに書き方を入れる。

=== 見出し

一番大きな見出し以外は使用できないので注意してください（スラ
イドではタイトル以外の見出しは必要ありませんよね？）。

TODO: スライドプロパティでは使う。なので、ここは更新しないと
いけない。

=== 注釈

使えますが、プレゼンテーションでは使うべきではないと思います。

