% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{DataGeNET.RDF-class}
\alias{DataGeNET.RDF-class}
\title{Class DataGeNET.RDF}
\description{
Class \code{DataGeNET.RDF} is the basic object generated when RDF is needed.
It can be passed to other disgenet2r package functions.
}
\section{Slots}{

\describe{
\item{\code{input}}{Character containing \code{'ontology'}, \code{'phenotype'} or
\code{'disease'}. used as input to the query.}

\item{\code{search}}{Character containing \code{'ontology'},  \code{'phenotype'} or
\code{'disease'} it is looking for.It is used to perform the correct query}

\item{\code{database}}{Character containing the name of the database that will be
queried. It can take the values
\code{'CTD_human'} to use Comparative Toxicogenomics Database, human data;
\code{'UNIPROT'} to use Universal Protein Resource;
\code{'CLINGEN'} to use Clinical Genome Resource;
\code{'CGI'} to use Cancer Genome Interpreter;
\code{'ORPHANET'}, to use Orphanet, the portal for rare diseases and orphan drugs;
\code{'PSYGENET'} to use PSYGENET;
\code{'GENOMICS_ENGLAND'} to use GENOMICS England;
\code{'CURATED'} to use expert curated, human databases;
\code{'HPO'} to use HPO;
\code{'INFERRED'} to use inferred data from HPO, GWASDB, GWASCAT, and CLINVAR;
\code{'CTD_rat'} to use Comparative Toxicogenomics Database, rat data;
\code{'CTD_mouse'} to use Comparative Toxicogenomics Database, mouse data;
\code{'RGD'}, to use Rat Genome Database;
\code{'MGD'}, to use the Mouse Genome Database;
\code{'ANIMAL_MODELS'} to use the expert curated, animal models data;
\code{'GWASCAT'} to use the NHGRI-EBI GWAS Catalog;
\code{'GWASDB'} to use the GWAS Database GWASdb;
\code{'CLINVAR'} to use ClinVar, a public archive of relationships
among sequence variation and human phenotype;
\code{'BEFREE'} to use text mining data, generated using BeFree System;
\code{'ALL'} to use all these databases. Default \code{'CURATED'}.}

\item{\code{scoreRange}}{the disGeNET score range to retrieved the GDAs/VDAs}

\item{\code{selection}}{Character containing the name of the ontoloyg selected}

\item{\code{mapping}}{Number with the mappings obtained.}

\item{\code{qresult}}{\code{data.frame} with the obtained result}
}}

\seealso{
ontology2disease, disease2ontology, phenotype2disease, disease2phenotype
}
