% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install-github.R
\name{github_remote}
\alias{github_remote}
\title{Create a new github_remote}
\usage{
github_remote(
  repo,
  ref = "HEAD",
  subdir = NULL,
  auth_token = github_pat(),
  sha = NULL,
  host = "api.github.com",
  ...
)
}
\arguments{
\item{repo}{Repository address in the format
\verb{username/repo[/subdir][@ref|#pull|@*release]}. Alternatively, you can
specify \code{subdir} and/or \code{ref} using the respective parameters
(see below); if both are specified, the values in \code{repo} take
precedence.}

\item{ref}{Desired git reference. Could be a commit, tag, or branch
name, or a call to \code{\link[=github_pull]{github_pull()}} or \code{\link[=github_release]{github_release()}}. Defaults to
\code{"HEAD"}, which means the default branch on GitHub and for git remotes.
See \href{https://help.github.com/en/github/administering-a-repository/setting-the-default-branch}{setting-the-default-branch}
for more details.}

\item{subdir}{subdirectory within repo that contains the R package.}

\item{auth_token}{To install from a private repo, generate a personal
access token (PAT) in "https://github.com/settings/tokens" and
supply to this argument. This is safer than using a password because
you can easily delete a PAT without affecting any others. Defaults to
the \code{GITHUB_PAT} environment variable.}

\item{host}{GitHub API host to use. Override with your GitHub enterprise
hostname, for example, \code{"github.hostname.com/api/v3"}.}

\item{...}{Other arguments passed on to \code{\link[utils:install.packages]{utils::install.packages()}}.}
}
\description{
This is an internal function to create a new github_remote, users should
generally have no need for it.
}
\keyword{internal}
