% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tool_methods.R
\name{nobs.plm}
\alias{nobs.plm}
\alias{nobs}
\alias{nobs.panelmodel}
\alias{nobs.pgmm}
\title{Extract Total Number of Observations Used in Estimated Panelmodel}
\usage{
\method{nobs}{panelmodel}(object, ...)

\method{nobs}{pgmm}(object, ...)
}
\arguments{
\item{object}{a \code{panelmodel} object for which the number of
total observations is to be extracted,}

\item{\dots}{further arguments.}
}
\value{
A single number, normally an integer.
}
\description{
This function extracts the total number of 'observations' from a
fitted panel model.
}
\details{
The number of observations is usually the length of the residuals
vector. Thus, \code{nobs} gives the number of observations actually
used by the estimation procedure. It is not necessarily the number
of observations of the model frame (number of rows in the model
frame), because sometimes the model frame is further reduced by the
estimation procedure. This is e.g. the case for first--difference
models estimated by \code{plm(..., model = "fd")} where the model
frame does not yet contain the differences (see also
\strong{Examples}).
}
\examples{

# estimate a panelmodel
data("Produc", package = "plm")
z <- plm(log(gsp)~log(pcap)+log(pc)+log(emp)+unemp,data=Produc,
         model="random", subset = gsp > 5000)
         
nobs(z)       # total observations used in estimation
pdim(z)$nT$N  # same information
pdim(z)       # more information about the dimensions (no. of individuals and time periods)

# illustrate difference between nobs and pdim for first-difference model
data("Grunfeld", package = "plm")
fdmod <- plm(inv ~ value + capital, data = Grunfeld, model = "fd")
nobs(fdmod)      # 190
pdim(fdmod)$nT$N # 200

}
\seealso{
\code{\link[=pdim]{pdim()}}
}
\keyword{attribute}
