% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sCorrect-summary.glht2.R
\name{summary.glht2}
\alias{summary.glht2}
\title{Outcome of Linear Hypothesis Testing}
\usage{
\method{summary}{glht2}(
  object,
  confint = TRUE,
  conf.level = 0.95,
  transform = NULL,
  seed = NULL,
  rowname.rhs = TRUE,
  ...
)
}
\arguments{
\item{object}{a \code{glht2} object.}

\item{confint}{[logical] should confidence intervals be output}

\item{conf.level}{[numeric 0-1] level of the confidence intervals.}

\item{transform}{[function] function to backtransform the estimates, standard errors, null hypothesis, and the associated confidence intervals
(e.g. \code{exp} if the outcomes have been log-transformed).}

\item{seed}{[integer] value that will be set before adjustment for multiple comparisons to ensure reproducible results.
Can also be \code{NULL}: in such a case no seed is set.}

\item{rowname.rhs}{[logical] when naming the hypotheses, add the right-hand side (i.e. "X1-X2=0" instead of "X1-X2").}

\item{...}{argument passed to \code{multcomp:::summary.glht}, e.g. argument \code{test} to choose the type of adjustment for multiple comparisons.}
}
\description{
Estimates, p-values, and confidence intevals for linear hypothesis testing, possibly adjusted for multiple comparisons.
}
