% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_w_connected_cmpts.R
\name{get_w_connected_cmpts}
\alias{get_w_connected_cmpts}
\title{Get all nodes associated with connected components}
\usage{
get_w_connected_cmpts(graph)
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}
}
\value{
A data frame with nodes and their membership in different weakly
connected components.
}
\description{
Determine which nodes in a graph belong to different weakly connected
components (i.e., distinct sets of nodes with traversable paths to and from
each node in the set).
}
\examples{
# Create a graph with 2 cycles
graph <-
  create_graph() \%>\%
  add_cycle(n = 4) \%>\%
  add_cycle(n = 3)

# Check if the graph is connected
graph \%>\%
  is_graph_connected()

# Get the graph's weakly-connected
# components
graph \%>\% get_w_connected_cmpts()

}
