% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjustLogRatio.R
\name{adjustLogRatio}
\alias{adjustLogRatio}
\title{Adjust tumor vs. normal coverage log ratio for tumor purity and ploidy}
\usage{
adjustLogRatio(ratio, purity, ploidy, is.log2 = TRUE, min.ratio = 2^-8)
}
\arguments{
\item{ratio}{Vector of log2 tumor vs normal coverage ratios.}

\item{purity}{Purity of sample.}

\item{ploidy}{Ploidy of sample.}

\item{is.log2}{\code{log.ratio} is \code{log2} transformed.}

\item{min.ratio}{Minimum (non-log2-transformed) ratio. Set to approx -8
\code{log2} adjusted.}
}
\value{
\code{numeric(length(log.ratio))}, \code{log.ratio} adjusted 
for \code{purity} and \code{ploidy}
}
\description{
This function can be used to adjust the log ratio for tumor purity and
ploidy for downstream tools that expect a log2 ratio (for example GISTIC).
}
\examples{

normal.coverage.file <- system.file("extdata", "example_normal.txt.gz", 
    package = "PureCN")
tumor.coverage.file <- system.file("extdata", "example_tumor.txt.gz", 
    package = "PureCN")
normal <- readCoverageFile(normal.coverage.file)
tumor <- readCoverageFile(tumor.coverage.file)
log.ratio <- calculateLogRatio(normal, tumor)
log.ratio.adjusted <- adjustLogRatio(log.ratio, 0.65, 1.73)

}
\references{
Nature Biotechnology.
 * Toal (2018), https://github.com/lima1/PureCN/issues/40
}
\author{
Markus Riester
}
