% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mut_matrix.R
\name{mut_matrix}
\alias{mut_matrix}
\title{Make mutation count matrix of 96 trinucleotides}
\usage{
mut_matrix(vcf_list, ref_genome, extension = 1)
}
\arguments{
\item{vcf_list}{GRangesList or GRanges object.}

\item{ref_genome}{BSGenome reference genome object}

\item{extension}{The number of bases, that's extracted upstream and
downstream of the base substitutions. (Default: 1).}
}
\value{
96 mutation count matrix
}
\description{
Make 96 trinucleotide mutation count matrix
}
\examples{
## See the 'read_vcfs_as_granges()' example for how we obtained the
## following data:
grl <- readRDS(system.file("states/read_vcfs_as_granges_output.rds",
  package = "MutationalPatterns"
))

## Load the corresponding reference genome.
ref_genome <- "BSgenome.Hsapiens.UCSC.hg19"
library(ref_genome, character.only = TRUE)

## Construct a mutation matrix from the loaded VCFs in comparison to the
## ref_genome.
mut_mat <- mut_matrix(vcf_list = grl, ref_genome = ref_genome)

## Construct a mutation matrix with a larger context.
## This is most usefull when you have many mutations per sample.
mut_mat_extended <- mut_matrix(vcf_list = grl, ref_genome = ref_genome, extension = 2)
}
\seealso{
\code{\link{read_vcfs_as_granges}}
}
