% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{add_mofa_factors_to_seurat}
\alias{add_mofa_factors_to_seurat}
\title{Function to add the MOFA representation onto a Seurat object}
\usage{
add_mofa_factors_to_seurat(
  mofa_object,
  seurat_object,
  views = "all",
  factors = "all"
)
}
\arguments{
\item{mofa_object}{a trained \code{\link{MOFA}} object.}

\item{seurat_object}{a Seurat object}

\item{views}{character vector with the view names, or numeric vector with view indexes. Default is 'all'}

\item{factors}{character vector with the factor names, or numeric vector with the factor indexes. Default is 'all'}
}
\value{
Returns a Seurat object with the 'reductions' slot filled with the MOFA factors. Also adds, if calculated, the UMAP/TSNE obtained with the MOFA factors.
}
\description{
Function to add the MOFA latent representation to a Seurat object
}
\details{
This function calls the \code{CreateDimReducObject} function from Seurat to store the MOFA factors.
}
\examples{
# Generate a simulated data set
MOFAexample <- make_example_data()
}
