% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decoupleR-pre.R
\name{intersect_regulons}
\alias{intersect_regulons}
\title{Intersect network target features with input matrix.}
\usage{
intersect_regulons(mat, network, .source, .target, minsize)
}
\arguments{
\item{mat}{Matrix to evaluate (e.g. expression matrix).
Target nodes in rows and conditions in columns.
\code{rownames(mat)} must have at least one intersection with the elements
in \code{network} \code{.target} column.}

\item{network}{Tibble or dataframe with edges and it's associated metadata.}

\item{.source}{Column with source nodes.}

\item{.target}{Column with target nodes.}

\item{minsize}{Minimum number of targets per source allowed.}
}
\value{
Filtered tibble.
}
\description{
Keep only edges which its target features belong to the input matrix.
}
\examples{
inputs_dir <- system.file("testdata", "inputs", package = "decoupleR")
mat <- readRDS(file.path(inputs_dir, "mat.rds"))
net <- readRDS(file.path(inputs_dir, "net.rds"))
intersect_regulons(mat, net, source, target, minsize=4)
}
