# File Version : 3.0.0.305
# pyOCD debugger
# Copyright (c) 2020 Arm Limited
# Copyright (c) 2020 Cypress Semiconductor Corporation
# SPDX-License-Identifier: Apache-2.0
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

flash_algo = {
    'load_address' : 0x08000000,

    # Flash algorithm as a hex string
    'instructions': [
    0xE00ABE00, 0x062D780D, 0x24084068, 0xD3000040, 0x1E644058, 0x1C49D1FA, 0x2A001E52, 0x4770D1F2,
    0x4605b5f8, 0x4617460e, 0xfb1cf000, 0x46204604, 0xb570bdf8, 0xf0004605, 0x4604fb1c, 0xbd704620,
    0xf000b510, 0x4604fb40, 0xbd104620, 0x4604b570, 0xf0004620, 0x4605fb5c, 0xbd704628, 0x4605b5f8,
    0x4614460f, 0x46284621, 0xfb5af000, 0x46304606, 0xb5f8bdf8, 0x460d4604, 0x46274616, 0x46294632,
    0xf0004620, 0x4607fb58, 0xbdf84638, 0x4604b5f8, 0x4616460d, 0x46294632, 0xf0004620, 0x4607fb63,
    0xbdf84638, 0x47706001, 0x600a6802, 0x21004770, 0x1c49e000, 0x43424a02, 0xd8fa428a, 0x00004770,
    0x00000d05, 0x4669b538, 0xf7ff4840, 0x210fffed, 0x98000209, 0x28004008, 0x2001d101, 0x2000e000,
    0x46204604, 0xb510bd38, 0x48392400, 0x78004448, 0xd1632800, 0xffe6f7ff, 0x40482101, 0x44494934,
    0x46087208, 0xf9e9f000, 0x2c004604, 0x4830d14e, 0x78404448, 0xd13a2801, 0x4448482d, 0x28007880,
    0x482bd109, 0x78c04448, 0xd10428e2, 0x49282000, 0x72484449, 0x4826e02b, 0x78804448, 0xd1092802,
    0x44484823, 0x28e478c0, 0x2002d104, 0x44494920, 0xe01c7248, 0x4448481e, 0x28057880, 0x481cd109,
    0x78c04448, 0xd10428e7, 0x49192005, 0x72484449, 0x4817e00d, 0x78804448, 0xd108280e, 0x44484814,
    0x28ea78c0, 0x200ed103, 0x44494911, 0x48107248, 0x7a004448, 0xd0052800, 0xf972f000, 0xd0012800,
    0xe0002001, 0x490a2000, 0x72884449, 0xd1012c00, 0xe0002001, 0x49062000, 0x70084449, 0x44484804,
    0x4803bd10, 0x78004448, 0x00004770, 0x40210400, 0x00000004, 0x49fbb510, 0x48fb4449, 0xff64f7ff,
    0xb508bd10, 0x48f84669, 0xff5ef7ff, 0x444848f5, 0x99006800, 0xd0054288, 0x444848f2, 0x48f26801,
    0xff50f7ff, 0xb570bd08, 0xff6df7ff, 0x28007a00, 0x2001d001, 0x2000e000, 0x46284605, 0x24013010,
    0x49e84084, 0x48e84449, 0xff3ef7ff, 0x444848e5, 0x40206800, 0xd1072800, 0x444848e2, 0x43206800,
    0x48e14601, 0xff2ef7ff, 0xb5f0bd70, 0x4606b085, 0x4617460c, 0x90032000, 0x01702500, 0x184049db,
    0xbf009001, 0x90002000, 0x9801a902, 0xf7ff3010, 0x9802ff1b, 0x90000fc0, 0xd0022c00, 0x28009800,
    0x2c00d104, 0x9800d104, 0xd1012800, 0xe0002001, 0x46052000, 0xd1082d00, 0x1c409803, 0x42b89003,
    0xe004d300, 0xf7ff2001, 0x2d00ff02, 0xbf00d0da, 0x21014628, 0xb0054048, 0xb5febdf0, 0x460e4605,
    0x24002700, 0x49c10168, 0x90011840, 0x4669bf00, 0xf7ff9801, 0x9800fee9, 0x2c000fc4, 0x1c78d107,
    0x42b04607, 0xe004d300, 0xf7ff2001, 0x2c00fee0, 0xbf00d0ed, 0x21014620, 0xbdfe4048, 0x460eb5f7,
    0x27004614, 0xbf002500, 0x98004621, 0xfeccf7ff, 0x0f006820, 0x21050700, 0x42880749, 0x2001d101,
    0x2000e000, 0x2d004605, 0x1c78d107, 0x42b04607, 0xe004d300, 0xf7ff2001, 0x2d00feba, 0xbf00d0e4,
    0x21014628, 0xbdfe4048, 0xb083b5f3, 0x26002400, 0xff37f7ff, 0xd0032800, 0xfec5f7ff, 0xe0037a00,
    0xfeb0f7ff, 0x40482101, 0x98029002, 0xd1022800, 0x4e962500, 0x9802e007, 0xd1032801, 0x4e932501,
    0xe0003620, 0x2c002401, 0x217dd13b, 0x462800c9, 0xff93f7ff, 0x2c004604, 0x9803d133, 0x0fc007c0,
    0x40482101, 0x98019001, 0xd0022800, 0x44484888, 0x9803e000, 0x46394607, 0x300c4630, 0xfe72f7ff,
    0x46302101, 0xf7ff3008, 0x4a82fe6d, 0x46282100, 0xff3bf7ff, 0x2c004604, 0x9801d112, 0xd0072800,
    0x31f521ff, 0x9a044638, 0xff88f7ff, 0xe0074604, 0x31f521ff, 0x300c4630, 0xf7ff9a04, 0x4604ff7f,
    0x4620bf00, 0xbdf0b005, 0xb087b5ff, 0x460e4605, 0x9c124617, 0x90062000, 0x99102004, 0xff4df7ff,
    0x68206020, 0xd1272800, 0x81054668, 0x97048146, 0x9005980a, 0x4865a902, 0xf7ff308c, 0x2120fe33,
    0x30884862, 0xfe2ef7ff, 0x20042100, 0xf7ff9a11, 0x6020fefc, 0x28006820, 0xa901d10d, 0x308c485b,
    0xfe22f7ff, 0x90069801, 0x68409806, 0xd0012800, 0x60202001, 0xbf00bf00, 0x68809806, 0xbdf0b00b,
    0xa803b51f, 0x91002102, 0x461a2300, 0x90029101, 0x20042106, 0xffb8f7ff, 0x28009803, 0x2001d101,
    0x2000e000, 0x46204604, 0xbd10b004, 0xb085b5f0, 0x460d4604, 0x461f4616, 0x90032000, 0x4945a803,
    0x00d2227d, 0x9200463b, 0x90029101, 0x46294632, 0xf7ff4620, 0xb005ff99, 0xb57cbdf0, 0x26004604,
    0xa9011c70, 0xff30f7ff, 0x2d004605, 0x21ffd129, 0x98010209, 0x0a004008, 0x98017060, 0x020970a0,
    0x40089801, 0x71600c00, 0x360126ff, 0x46691c70, 0xff1af7ff, 0x2d004605, 0x21ffd112, 0x98000209,
    0x0a004008, 0x980070e0, 0x210f7120, 0x98000409, 0x0c004008, 0x010971a0, 0x40089800, 0x71e00d00,
    0x4628bf00, 0xb508bd7c, 0x48214923, 0xf7ff4448, 0x4669fda9, 0xf7ff4820, 0xbd08fef7, 0x4604b538,
    0x444d4d1b, 0x4628491d, 0xfd9cf7ff, 0x1d284621, 0xfd98f7ff, 0x48194669, 0xfee6f7ff, 0xb538bd38,
    0x4d134604, 0x4916444d, 0xf7ff4628, 0x4621fd8b, 0xf7ff1d28, 0x4669fd87, 0xf7ff4811, 0xbd38fed5,
    0x4604b538, 0x444d4d0a, 0x4628490d, 0xfd7af7ff, 0x1d284621, 0xfd76f7ff, 0x48094669, 0xfec4f7ff,
    0x0000bd38, 0x00000010, 0x40231008, 0x40230000, 0x00000014, 0x00003a98, 0x0a000100, 0x1c000100,
    0x14000100, 0x4605b5f8, 0x4c1b460e, 0x491b444c, 0xf7ff4620, 0x21fffd57, 0x1d203107, 0xfd52f7ff,
    0x46204629, 0xf7ff3008, 0x4631fd4d, 0x300c4620, 0xfd48f7ff, 0x48114669, 0xfe96f7ff, 0xb5f8bdf8,
    0x460e4605, 0x444c4c0c, 0x4620490d, 0xfd3af7ff, 0x310721ff, 0xf7ff1d20, 0x4629fd35, 0x30084620,
    0xfd30f7ff, 0x46204631, 0xf7ff300c, 0x4669fd2b, 0xf7ff4803, 0xbdf8fe79, 0x00000014, 0x06000100,
    0x05000100, 0xf7ffb510, 0xf7fffdb5, 0x2000fdcc, 0xb510bd10, 0xfdb5f7ff, 0xbd102000, 0x4604b570,
    0x02492101, 0x44484840, 0xf8a6f000, 0x4449493e, 0xf7ff4620, 0x4605ffc4, 0xbd704628, 0x4606b570,
    0x2500460c, 0x4630e00a, 0xffe8f7ff, 0x2d004605, 0xe005d000, 0x36ff36ff, 0x1e643602, 0xd1f22c00,
    0x4628bf00, 0xb510bd70, 0xbf002400, 0x482f2104, 0xffe4f7ff, 0x2c004604, 0xe015d000, 0x482c2101,
    0xffdcf7ff, 0x2c004604, 0xe00dd000, 0x48292106, 0xffd4f7ff, 0x2c004604, 0xe005d000, 0x48262102,
    0xffccf7ff, 0xbf004604, 0x4620bf00, 0xb570bd10, 0x25004604, 0xf7ff4620, 0x4605ffb1, 0xbd704628,
    0x4604b570, 0x2600460d, 0x46204629, 0xff77f7ff, 0x46304606, 0xb5f8bd70, 0x460c4603, 0x18582100,
    0x93002500, 0xd10c2d00, 0xe006bf00, 0x9e005c57, 0x42b75c76, 0xe002d000, 0x42a11c49, 0xbf00d3f6,
    0xbdf81858, 0x4603b5f0, 0x2000460c, 0x461e4625, 0xe0052100, 0x42975c77, 0x2001d001, 0x1c49e002,
    0xd3f742a9, 0xbdf0bf00, 0x00000028, 0x16000800, 0x16001a00, 0x16005a00, 0x16007c00, 0xc004e001,
    0x29041f09, 0x078bd2fb, 0x8002d501, 0x07c91c80, 0x7002d000, 0x29004770, 0x07c3d00b, 0x7002d002,
    0x1e491c40, 0xd3042902, 0xd5020783, 0x1c808002, 0xe7e31e89, 0xe7ee2200, 0xe7df2200, 0x00000000,
    0xffffff00, 0xffffffff, 0x0000ffff, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000
    ],

    # Relative function addresses
    'pc_init': 0x08000021,
    'pc_unInit': 0x08000033,
    'pc_program_page': 0x0800005d,
    'pc_erase_sector': 0x0800004d,
    'pc_eraseAll': 0x08000041,

    'static_base' : 0x08000000 + 0x00000020 + 0x000007bc,
    'begin_stack' : 0x08001f00,
    'begin_data' : 0x08001f00 + 0x40,
    'page_size' : 0x200,
    'analyzer_supported' : False,
    'analyzer_address' : 0x00000000,
    'page_buffers' : [0x08001f40, 0x08002140],   # Enable double buffering
    'min_program_length' : 0x200,

    # Flash information
    'flash_start': 0x16000000,
    'flash_size': 0x8000,
    'sector_sizes': (
        (0x0, 0x200),
    )
}
