/**********************************************************************
 *
 *    FILE:            Switch.cpp
 *
 *    DESCRIPTION:    Read/Write osg::Switch in binary format to disk.
 *
 *    CREATED BY:        Auto generated by iveGenerator
 *                    and later modified by Rune Schmidt Jensen.
 *
 *    HISTORY:        Created 9.4.2003
 *
 *    Copyright 2003 VR-C
 **********************************************************************/

#include "Exception.h"
#include "Switch.h"
#include "Group.h"

using namespace ive;

void Switch::write(DataOutputStream* out){
    // Write Switch's identification.
    out->writeInt(IVESWITCH);
    // If the osg class is inherited by any other class we should also write this to file.
    osg::Group*  group = dynamic_cast<osg::Group*>(this);
    if(group){
        ((ive::Group*)(group))->write(out);
    }
    else
        out_THROW_EXCEPTION("Switch::write(): Could not cast this osg::Switch to an osg::Group.");
    // Write Switch's properties.

    // Write childrens value.
    for(unsigned int i=0; i<getNumChildren();i++)
        out->writeBool(getValue(i));

}

void Switch::read(DataInputStream* in){
    // Peek on Switch's identification.
    int id = in->peekInt();
    if(id == IVESWITCH){
        // Read Switch's identification.
        id = in->readInt();
        // If the osg class is inherited by any other class we should also read this from file.
        osg::Group*  group = dynamic_cast<osg::Group*>(this);
        if(group){
            ((ive::Group*)(group))->read(in);
        }
        else
            in_THROW_EXCEPTION("Switch::read(): Could not cast this osg::Switch to an osg::Group.");
        // Read Switch's properties

        // Read childrens value.
        for(unsigned int i=0; i<getNumChildren();i++)
            setValue(i, in->readBool());

    }
    else{
        in_THROW_EXCEPTION("Switch::read(): Expected Switch identification.");
    }
}
