<!-- SPDX-License-Identifier: CC-BY-4.0 -->
<!-- Copyright Contributors to the OpenColorIO Project. -->

Mar 4, 2019

Host: Michael Dolan

Rotating Secretary: Michael Dolan

Attendees:
  * [X] Mark Boorer (_TSC_) - Industrial Light & Magic
  * [X] Sean Cooper (_TSC_) - DNEG
  * [X] Michael Dolan (_TSC Chair_) - Sony Pictures Imageworks
  * [X] Larry Gritz (_TSC_) - Sony Pictures Imageworks
  * [X] Thanh Ha - Academy Software Foundation / Linux Foundation
  * [ ] Patrick Hodoul (_TSC_) - Autodesk
  * [X] John Mertic - Academy Software Foundation / Linux Foundation
  * [X] Carl Rand (_TSC_) - Foundry
  * [X] Doug Walker (_TSC Chief Architect_) - Autodesk
  * [X] Kevin Wheatley (_TSC_) - Framestore

# **OCIO TSC Meeting Notes**

* Feature preview tag / Early 2.0 release
    - Decision to NOT do either a preview tag or early 2.0 release
        - Doug: As established in the initial 2.0 proposal, this is not feasible.
        - The plan remains to release a complete feature set when the full v2 roadmap is completed.
    - Community concern is that the v2 release schedule is unknown, and time between OCIO releases is long.
        - This can make planning for software vendors challenging, but preliminary implementation of the v2 interface is possible now from master for testing.
        - Autodesk discussing an official roadmap and insight on a potential release window. Stay tuned.
        - Long PR review cycles contribute to development slowdowns:
            - Most PRs are merged with the 2 week single reviewer clause.
            - Larry: If current merge policies are a roadblock to AD, can they be revised?
                - Proposed rotating review duty for a TSC member to do initial PR reviews as they are submitted for their assigned week
            - This needs to be improved if it's blocking.
            - Doug: Feature interdependency part of the challenge:
                - PRs are becoming smaller, more focused, which should help with review accessability
            - **TODO**: Doug/Patrick to review and report back on what project management changes could help them
    - Larry: Should we have a known commit for testing a given feature (i.e. GPU renderer) for internal testing purposes.
        - Doug: Testing off of master at any given time is stable, and ideal.

* ASWF/LF CI update from TAC meeting
    - Thanh presented comparison of Circle CI and current Jenkins infrastructure:
        - Overall, TAC impression is that Circle seems like a better choice, but pricing and logistics needs further investigation.
        - Circle supports local CI, allowing contributors to test CI *before* submitting a PR.
        - Supports GPUs when hosted on our servers, but pricing may be a concern.
        - Proposed AppVeyor for Windows support for now.
    - OpenVDB reports that Circle significantly faster than Travis
    - Larry: Circle has better, faster CPUs than Travis
    - **TODO**: Once ASWF/LF commit to CI choice, Mark/Sean to investigate transition to new CI infastructure
        - If OpenVDB adopts new system first, we can reference their setup.

* Moving OCIO to ASWF Git organization
    - Legal approvals for OCIO domain tranfer are complete!
    - The GitHub account move should be fairly straightforward, but may bring down CI builds for a day or two during the transition.
    - **TODO**: LF needs Travis and AppVeyor accounts created before we can move repo, to host CI builds.
    - **TODO**: Larry/Michael to work with John/Thanh to facilitate the account move.
    - There may be a requirement to fix some of the embedded external dependencies *before* the repo move to satisfy detected license issues (from the license scan).
        - Patrick made a GH issue for further discussion on 3rd-party dependencies: #690

* OCIO v2 Python bindings
    - SPI proposes contributing new bindings via pybind11:
        - Mark: Current OCIO bindings have no external dependency. Are we sure we want to introduce one, vs. using Python's C API?
            - Larry: Supporting both Python 2 and 3 would make use of C API more complicated. pybind11 is simple to implement, and header only.
    - Sean: Good opportunity to improve consistency in Python interface:
        - Currently there are inconsistencies with argument and return types.
        - Implementors are not always sure what types they'll get back from the API.
    - Larry: proposes a design PR be created first (using new GH feature), which outlines the new interface, prior to actually doing the work.
    - **TODO**: Michael to create new Python API design and submit PR for feedback/discussion/approval.

* Apple has deprecated OpenGL
    - Mark: One option could be to build a bridget between Vulcan and Metal. Proposes use of MoltenVK.
    - Sean: SPIRV-Cross also worth investigation.
    - Doug: We're not sure yet when OpenGL support will actually be removed by Apple.
        - From my point of view, OCIO will definitely need to support low-level graphics APIs such as Vulkan and Metal, so the question is more when than if.
        - Agreed MoltenVK is one option to investigate.
    - Carl: Different parties within Apple have different opinions of timeline for dropping support.
    - Mark: Nothing in OCIO's design is preventing Metal support from being added now.
        - Doug: Investigation is needed not only on the shader language but also on how textures will be managed under a low-level graphics API.

* 2019 SIGGRAPH BoF
    - ASWF BoFs will be back to back.
    - Mark: a smaller fishbowl room is preferred for the OCIO BoF, instead of a large hall (like what ACES had in 2018).
        - This is an important meeting for the community. Need to make sure the format is not impacted.
    - Effort should be taken (as much as possible) to avoid the OCIO BoF intersecting with other color talks.
    - Valid points to raise to LF/ASWF as the overall event is organized.
    - All that being said, having LF/ASWF help is getting these sessions organized is much appreciated.

* OCIO-Configs ACES 1.1
    - Carl raised question of an official ACES 1.1 OCIO config availability. Nuke team is asking.
    - Doug: 1.1 has some key differences from 1.0.3, which will need to be taken into account (i.e., new outputTransform)
    - Contributors who have been supporting these configs are busy with other projects, so timeline is uncertain.
    - **TODO**: Foundry to follow up in ocio-user mail list and/or Slack, to see if anyone can offer a status update.

* Items for next TSC meeting agenda:
    - Status update on GH project move to ASWF account, and any impact this has on other TODOs.
