type token =
  | TokEof
  | TokLeftParen of (Lm_location.t)
  | TokRightParen of (Lm_location.t)
  | TokLeftBrack of (Lm_location.t)
  | TokRightBrack of (Lm_location.t)
  | TokPlus of (Lm_location.t)
  | TokMinus of (Lm_location.t)
  | TokStar of (Lm_location.t)
  | TokSlash of (Lm_location.t)
  | TokMod of (Lm_location.t)
  | TokHat of (Lm_location.t)
  | TokPipe of (Lm_location.t)
  | TokAmp of (Lm_location.t)
  | TokLsl of (Lm_location.t)
  | TokLsr of (Lm_location.t)
  | TokAsr of (Lm_location.t)
  | TokAnd of (Lm_location.t)
  | TokOr of (Lm_location.t)
  | TokDot of (Lm_location.t)
  | TokComma of (Lm_location.t)
  | TokSemi of (Lm_location.t)
  | TokLe of (Lm_location.t)
  | TokLt of (Lm_location.t)
  | TokEq of (Lm_location.t)
  | TokNeq of (Lm_location.t)
  | TokGt of (Lm_location.t)
  | TokGe of (Lm_location.t)
  | TokColonColon of (Lm_location.t)
  | TokArrow of (Lm_location.t)
  | TokId of (Lm_symbol.t * Lm_location.t)
  | TokKey of (Lm_symbol.t * Lm_location.t)
  | TokCatch of (Lm_location.t)
  | TokInt of (int * Lm_location.t)
  | TokFloat of (float * Lm_location.t)
  | TokExp of (Omake_ast.exp)

val ast_exp :
  (Lexing.lexbuf  -> token) -> Lexing.lexbuf -> Omake_ast.exp
