# Check that mirrors are functioning.
#
# This script sets the following, which carries through to the rest of
# the program:
#
#     mirror-checks/$SNAPSHOT_TOC1
#
# Other things the script sets are only of local significance and can
# safely be overwritten by other scripts.

readonly MSGA_CHRS1='checking that both the regular mirror'
readonly MSGA_CHRS2='you have specified and'
readonly MSGA_CHRS3='the Debian Project'"'"'s snapshot service'
readonly MSGA_CHRS4='are available and functioning'
readonly MSGA_CHRS=$(gettext\
 "$MSGA_CHRS1 $MSGA_CHRS2 $MSGA_CHRS3 $MSGA_CHRS4")
readonly MSGA_CHR1='checking that the regular mirror'
readonly MSGA_CHR2='you have specified is available and functioning'
readonly MSGA_CHR=$(gettext "$MSGA_CHR1 $MSGA_CHR2")
readonly MSGA_MIR=$(gettext 'mirror %s does not properly respond')
readonly MSGA_IMIR=$(gettext 'iso/cd mirror %s does not properly respond, or the required iso/cd image is not yet available')
readonly MSGA_SS=$(gettext 'snapshot server %s does not properly respond')
readonly MSGA_CRS=$(gettext\
 'check complete: mirror and snapshot both respond')
readonly MSGA_CR=$(gettext 'check complete: mirror responds')

if (($OPT_PHASE_A)); then

    if (($OPT_BACKPORTS)); then
        inform "$MSGA_CHRS..."
    else
        inform "$MSGA_CHR..."
    fi
    function bail_from_phase_A_for_primary {
        die "$(printf "$MSGA_MIR" "$MIRROR_PRIMARY")"
    }
    function bail_from_phase_A_for_cd {
        die "$(printf "$MSGA_IMIR" "$MIRROR_PRIMARY")"
    }
    function bail_from_phase_A_for_snapshot {
        die "$(printf "$MSGA_SS" "$SNAPSHOT_SERVICE")"
    }
    mkdir $VV -- $TMPDIR/mirror-checks{-incoming,}

    rsync -tv --progress --stats --\
     "$MIRROR_PRIMARY::$ARCHIVE_NAME/$MIRROR_TEST_INCOMING"\
     "$TMPDIR/mirror-checks-incoming"\
     || bail_from_phase_A_for_primary
    mv $VV -- "$TMPDIR/mirror-checks-incoming/$MIRROR_TEST_INCOMING"\
     "$TMPDIR/mirror-checks/$MIRROR_TEST"\
     || bail_from_phase_A_for_primary
    [ -s "$TMPDIR/mirror-checks/$MIRROR_TEST" ]\
     || bail_from_phase_A_for_primary

    rsync -tv --progress --stats --\
     "$MIRROR_PRIMARY::$CD_ARCHIVE_NAME/$ISOCD_VER/$ARCH/iso-cd/$CD_MIRROR_TEST_INCOMING"\
     "$TMPDIR/mirror-checks-incoming"\
     || bail_from_phase_A_for_cd
    mv $VV -- "$TMPDIR/mirror-checks-incoming/$CD_MIRROR_TEST_INCOMING"\
     "$TMPDIR/mirror-checks/$CD_MIRROR_TEST"\
     || bail_from_phase_A_for_cd
    [ -s "$TMPDIR/mirror-checks/$CD_MIRROR_TEST" ]\
     || bail_from_phase_A_for_cd

    (($OPT_BACKPORTS)) && {
        # The next command helps administrators of snapshot.debian.org
        # [i] to measure the (presumably modest) fraction for which
        # mirrorrib installations like yours are collectively responsible
        # of the overall load on the service, [ii] to understand the reason
        # for what might otherwise appear to be mysterious, odd, or
        # suspicious accesses by you, and [iii] to advise this script's
        # maintainer to fix any unexpected problems the script might
        # inadvertently be causing the service. The file the command
        # attempts to fetch does not exist. All mirrorrib installations use
        # the same filename (for it is not the filename but your IP address
        # that distinguishes you from other mirrorrib users). If modifying
        # this script, you may strike the "2>/dev/null" from the command if
        # you prefer mirrorrib's standard error stream to report the
        # command's intentional failure but, otherwise, unless you have
        # reconfigured your mirrorrib installation not to access
        # snapshot.debian.org at all, please avoid altering the command.
        wget >/dev/null 2>/dev/null -nH -O- -P\
         "$TMPDIR/mirror-checks-incoming" --\
         "https://${SNAPSHOT_SERVICE%%/*}/static/auwobymhnpx01.html"\
         || true
        wget -nH -P "$TMPDIR/mirror-checks-incoming" --\
         "https://$SNAPSHOT_SERVICE/$ARCHIVE_NAME/"\
         || bail_from_phase_A_for_snapshot
        mv $VV -- "$TMPDIR/mirror-checks-incoming/index.html"\
         "$TMPDIR/mirror-checks/$SNAPSHOT_TOC1"\
         || bail_from_phase_A_for_snapshot
        [ -s "$TMPDIR/mirror-checks/$SNAPSHOT_TOC1" ]\
         || bail_from_phase_A_for_snapshot
    }

    if (($OPT_BACKPORTS)); then
        inform "$MSGA_CRS"
    else
        inform "$MSGA_CR"
    fi

fi

# The file $TMPDIR/mirror-checks/$SNAPSHOT_TOC1, used during this phase A
# to verify snapshot's responsiveness, will find another use during
# phase B. Phase B need not fetch it again.

true

