needsPackage "Dmodules"

------------------------------------
-- Brianson-Maisonobe-Merle formula
S = QQ[x,y,z,a,b,c]
cc = BMM({ideal S=>1},x^3+y^3+z^3)
assert(cc === {ideal S=>1, ideal(x^3+y^3+z^3)=>1, ideal(z,y,x)=>4})

/// This takes > 1 min...
-------------------------------------------------------------------------
-- Computation of the local cohomology CCs at the ideal
-- generated by the minors of 2x3 matrix of indeterminates
W =  QQ[x_1..x_6, a_1..a_6];
I = minors(2, matrix{{x_1, x_2, x_3}, {x_4, x_5, x_6}});
cc = {ideal W => 1};
B = populateCechComplexCC(I,cc)
pruneCechComplexCC B 
assert all({{0,1},{0,1,2}}, k-> #B#k > 0) 
assert all(toList(set keys B - set {{0,1},{0,1,2}}), k-> #B#k == 0) 
///
