'\" t
.\" Manual page created with latex2man on Thu Aug 16 09:44:44 MDT 2007
.\" NOTE: This file is generated, DO NOT EDIT.
.de Vb
.ft CW
.nf
..
.de Ve
.ft R

.fi
..
.TH "LIBUNWIND\-SETJMP" "3" "16 August 2007" "Programming Library " "Programming Library "
.SH NAME
libunwind\-setjmp
\-\- libunwind\-based non\-local gotos 
.PP
.SH SYNOPSIS

.PP
#include <setjmp.h>
.br
.PP
int
setjmp(jmp_buf env);
.br
void
longjmp(jmp_buf env,
int val);
.br
int
_setjmp(jmp_buf env);
.br
void
_longjmp(jmp_buf env,
int val);
.br
int
sigsetjmp(sigjmp_buf env,
int savemask);
.br
void
siglongjmp(sigjmp_buf env,
int val);
.br
.PP
.SH DESCRIPTION

.PP
The unwind\-setjmp
library offers a libunwind\-based
implementation of non\-local gotos. This implementation is intended to 
be a drop\-in replacement for the normal, system\-provided routines of 
the same name. The main advantage of using the unwind\-setjmp
library is that setting up a non\-local goto via one of the 
setjmp()
routines is very fast. Typically, just 2 or 3 words 
need to be saved in the jump\-buffer (plus one call to 
sigprocmask(2),
in the case of sigsetjmp).
On the 
other hand, executing a non\-local goto by calling one of the 
longjmp()
routines tends to be much slower than with the 
system\-provided routines. In fact, the time spent on a 
longjmp()
will be proportional to the number of call frames 
that exist between the points where setjmp()
and 
longjmp()
were called. For this reason, the 
unwind\-setjmp
library is beneficial primarily in applications 
that frequently call setjmp()
but only rarely call 
longjmp().
.PP
.SH CAVEATS

.PP
.TP
.B *
The correct operation of this library depends on the presence of 
correct unwind information. On newer platforms, this is rarely an 
issue. On older platforms, care needs to be taken to 
ensure that each of the functions whose stack frames may have to be 
unwound during a longjmp()
have correct unwind information 
(on those platforms, there is usually a compiler\-switch, such as 
\fB\-funwind\-tables\fP,
to request the generation of unwind 
information). 
.TP
.B *
The contents of jmp_buf and sigjmp_buf as setup
and used by these routines is completely different from the ones 
used by the system\-provided routines. Thus, a jump\-buffer created 
by the libunwind\-based setjmp()/_setjmp
may only be 
used in a call to the libunwind\-based 
longjmp()/_longjmp().
The analogous applies for 
sigjmp_buf
with sigsetjmp()
and siglongjmp().
.PP
.SH FILES

.PP
.TP
\fB\-l\fPunwind\-setjmp
 The library an application should 
be linked against to ensure it uses the libunwind\-based non\-local 
goto routines. 
.PP
.SH SEE ALSO

.PP
libunwind(3),
setjmp(3), longjmp(3), 
_setjmp(3), _longjmp(3), 
sigsetjmp(3), siglongjmp(3) 
.PP
.SH AUTHOR

.PP
David Mosberger\-Tang
.br
Email: \fBdmosberger@gmail.com\fP
.br
WWW: \fBhttp://www.nongnu.org/libunwind/\fP\&.
.\" NOTE: This file is generated, DO NOT EDIT.
