/*
 * Copyright (c) 2007-2010, Erik Lindroos <gliptic@gmail.com>
 * Copyright (c) 2010, "basro"
 * This software is released under the The BSD-2-Clause License:
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * * Redistributions of source code must retain the above copyright notice,
 *   this list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the documentation
 *   and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */


#include "commonController.hpp"

#include "../gfx.hpp"

CommonController::CommonController() 
: frameSkip(1)
, inverseFrameSkip(false)
, cycles(0)
{
}

bool CommonController::process()
{
	int newFrameSkip = 0;
	if(gfx.testSDLKeyOnce(SDLK_1))
		newFrameSkip = 1;
	else if(gfx.testSDLKeyOnce(SDLK_2))
		newFrameSkip = 2;
	else if(gfx.testSDLKeyOnce(SDLK_3))
		newFrameSkip = 4;
	else if(gfx.testSDLKeyOnce(SDLK_4))
		newFrameSkip = 8;
	else if(gfx.testSDLKeyOnce(SDLK_5))
		newFrameSkip = 16;
	else if(gfx.testSDLKeyOnce(SDLK_6))
		newFrameSkip = 32;
	else if(gfx.testSDLKeyOnce(SDLK_7))
		newFrameSkip = 64;
	else if(gfx.testSDLKeyOnce(SDLK_8))
		newFrameSkip = 128;
	else if(gfx.testSDLKeyOnce(SDLK_9))
		newFrameSkip = 256;
	else if(gfx.testSDLKeyOnce(SDLK_0))
		newFrameSkip = 512;
		
	if(newFrameSkip)
	{
		inverseFrameSkip = (gfx.testSDLKey(SDLK_RCTRL) || gfx.testSDLKey(SDLK_LCTRL));
		frameSkip = newFrameSkip;
	}
	
	++cycles;
		
	return true;
}
