/*
 * This program source code file is part of KiCad, a free EDA CAD application.
 *
 * Copyright (C) 2022 Mikolaj Wielgus
 * Copyright The KiCad Developers, see AUTHORS.TXT for contributors.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, you may find one here:
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * or you may search the http://www.gnu.org website for the version 2 license,
 * or you may write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 */

#include <sim/sim_model_ngspice.h>


void NGSPICE_MODEL_INFO_MAP::addBSIM4()
{
    modelInfos[MODEL_TYPE::BSIM4] = { "BSIM4", "NMOS", "PMOS", { "D", "G", "S", "B" }, "Berkeley Short Channel IGFET Model-4", {}, {} };
    // Model parameters
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "cvchargemod",  76, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0", "0", "Capacitance Charge model selector" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "capmod",  92, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "2", "2", "Capacitance model selector" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "diomod",  86, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Diode IV model selector" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rdsmod",  85, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Bias-dependent S/D resistance model selector" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "trnqsmod_",  93, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Transient NQS model selector" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "acnqsmod_",  83, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "AC NQS model selector" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "mobmod",  94, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Mobility model selector" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rbodymod_",  91, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Distributed body R model selector" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rgatemod_",  90, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate R model selector" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "permod",  87, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Pd and Ps model selector" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "geomod_",  88, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Geometry dependent parasitics model selector" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rgeomod_",  89, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "S/D resistance and contact model selector" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "fnoimod",  84, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "1", "1", "Flicker noise model selector" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "tnoimod",  95, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "0", "0", "Thermal noise model selector" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "mtrlmod",  80, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "parameter for non-silicon substrate or metal gate selector" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "mtrlcompatmod",  380, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "New Material Mod backward compatibility selector" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "igcmod",  81, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate-to-channel Ig model selector" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "igbmod",  82, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate-to-body Ig model selector" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "tempmod",  79, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature model selector" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "gidlmod",  379, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "parameter for GIDL selector" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "paramchk",  192, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Model parameter checking selector" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "binunit",  124, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Bin  unit  selector" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "version",  193, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_STRING, "", SIM_MODEL::PARAM::CATEGORY::DC, "4.8.1", "4.8.1", "parameter for model version" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "eot",  96, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1.5e-09", "1.5e-09", "Equivalent gate oxide thickness in meters" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "vddeot",  97, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "1.5", "-1.5", "Voltage for extraction of Equivalent gate oxide thickness" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "tempeot",  65, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "300.15", "300.15", "Temperature for extraction of EOT" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "leffeot",  66, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Effective length for extraction of EOT" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "weffeot",  67, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "10", "10", "Effective width for extraction of EOT" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ados",  77, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Charge centroid parameter" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "bdos",  78, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Charge centroid parameter" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "toxe",  98, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "3e-09", "3e-09", "Electrical gate oxide thickness in meters" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "toxp",  230, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "3e-09", "3e-09", "Physical gate oxide thickness in meters" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "toxm",  201, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "3e-09", "3e-09", "Gate oxide thickness at which parameters are extracted" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "toxref",  272, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "3e-09", "3e-09", "Target tox value" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "dtox",  231, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Defined as (toxe - toxp)" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "epsrox",  276, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "3.9", "3.9", "Dielectric constant of the gate oxide relative to vacuum" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "cdsc",  99, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0.00024", "0.00024", "Drain/Source and channel coupling capacitance" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "cdscb",  100, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body-bias dependence of cdsc" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "cdscd",  181, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Drain-bias dependence of cdsc" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "cit",  101, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0", "0", "Interface state capacitance" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "nfactor",  102, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Subthreshold swing Coefficient" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "xj",  103, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1.5e-07", "1.5e-07", "Junction depth in meters" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "vsat",  104, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m/s", SIM_MODEL::PARAM::CATEGORY::DC, "80000", "80000", "Saturation velocity at tnom" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "at",  105, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "33000", "33000", "Temperature coefficient of vsat" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "a0",  106, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Non-uniform depletion width effect coefficient." );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ags",  182, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate bias  coefficient of Abulk." );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "a1",  107, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Non-saturation effect coefficient" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "a2",  108, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Non-saturation effect coefficient" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "keta",  109, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "-0.047", "-0.047", "Body-bias coefficient of non-uniform depletion width effect." );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "phig",  111, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "4.05", "4.05", "Work function of gate" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "epsrgate",  112, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "11.7", "11.7", "Dielectric constant of gate relative to vacuum" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "easub",  113, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "4.05", "4.05", "Electron affinity of substrate" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "epsrsub",  114, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "11.7", "11.7", "Dielectric constant of substrate relative to vacuum" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ni0sub",  115, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1.45e+10", "1.45e+10", "Intrinsic carrier concentration of substrate at 300.15K" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "bg0sub",  116, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1.16", "1.16", "Band-gap of substrate at T=0K" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "tbgasub",  117, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0.000702", "0.000702", "First parameter of band-gap change due to temperature" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "tbgbsub",  118, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "1108", "1108", "Second parameter of band-gap change due to temperature" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "nsub",  110, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "1/cm³", SIM_MODEL::PARAM::CATEGORY::DC, "6e+16", "6e+16", "Substrate doping concentration" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ndep",  119, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1.7e+17", "1.7e+17", "Channel doping concentration at the depletion edge" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "nsd",  256, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1e+20", "1e+20", "S/D doping concentration" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "phin",  250, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Adjusting parameter for surface potential due to non-uniform vertical doping" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ngate",  120, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Poly-gate doping concentration" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "gamma1",  121, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Vth body coefficient" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "gamma2",  122, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Vth body coefficient" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "vbx",  123, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Vth transition body Voltage" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "vbm",  125, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "-3", "-3", "Maximum body voltage" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "xt",  126, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1.55e-07", "1.55e-07", "Doping depth" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "k1",  129, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "sqrt V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Bulk effect coefficient 1" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "kt1",  130, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "-0.11", "-0.11", "Temperature coefficient of Vth" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "kt1l",  131, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient of Vth" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "kt2",  133, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.022", "0.022", "Body-coefficient of kt1" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "k2",  132, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Bulk effect coefficient 2" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "k3",  134, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "80", "80", "Narrow width effect coefficient" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "k3b",  135, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body effect coefficient of k3" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "w0",  136, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "2.5e-06", "2.5e-06", "Narrow width effect parameter" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "dvtp0",  247, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "First parameter for Vth shift due to pocket" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "dvtp1",  248, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Second parameter for Vth shift due to pocket" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "dvtp2",  468, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "3rd parameter for Vth shift due to pocket" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "dvtp3",  469, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "4th parameter for Vth shift due to pocket" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "dvtp4",  470, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "5th parameter for Vth shift due to pocket" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "dvtp5",  471, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "6th parameter for Vth shift due to pocket" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lpe0",  137, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1.74e-07", "1.74e-07", "Equivalent length of pocket region at zero bias" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lpeb",  246, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Equivalent length of pocket region accounting for body bias" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "dvt0",  138, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "2.2", "2.2", "Short channel effect coeff. 0" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "dvt1",  139, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.53", "0.53", "Short channel effect coeff. 1" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "dvt2",  140, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "-0.032", "-0.032", "Short channel effect coeff. 2" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "dvt0w",  141, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Narrow Width coeff. 0" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "dvt1w",  142, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "5.3e+06", "5.3e+06", "Narrow Width effect coeff. 1" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "dvt2w",  143, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "-0.032", "-0.032", "Narrow Width effect coeff. 2" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "drout",  144, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0.56", "0.56", "DIBL coefficient of output resistance" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "dsub",  145, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.56", "0.56", "DIBL coefficient in the subthreshold region" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "vth0",  146, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "0.7", "-0.7", "Threshold voltage" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "vtho",  146, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0.7", "-0.7", "n.a." );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ua",  147, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1e-09", "1e-09", "Linear gate dependence of mobility" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ua1",  148, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "1e-09", "1e-09", "Temperature coefficient of ua" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ub",  149, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1e-19", "1e-19", "Quadratic gate dependence of mobility" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ub1",  150, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "-1e-18", "-1e-18", "Temperature coefficient of ub" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "uc",  151, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "-4.65e-11", "-4.65e-11", "Body-bias dependence of mobility" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "uc1",  152, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "-5.6e-11", "-5.6e-11", "Temperature coefficient of uc" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ud",  290, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Coulomb scattering factor of mobility" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ud1",  291, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient of ud" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "up",  292, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Channel length linear factor of mobility" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lp",  293, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1e-08", "1e-08", "Channel length exponential factor of mobility" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "u0",  153, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.067", "0.025", "Low-field mobility at Tnom" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "eu",  234, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1.67", "1", "Mobility exponent" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ucs",  72, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1.67", "1", "Colombic scattering exponent" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ute",  154, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "-1.5", "-1.5", "Temperature coefficient of mobility" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ucste",  68, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "-0.004775", "-0.004775", "Temperature coefficient of colombic mobility" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "voff",  155, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "-0.08", "-0.08", "Threshold voltage offset" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "minv",  237, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Fitting parameter for moderate inversion in Vgsteff" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "minvcv",  296, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Fitting parameter for moderate inversion in Vgsteffcv" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "voffl",  238, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence parameter for Vth offset" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "voffcvl",  297, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence parameter for Vth offset in CV" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "tnom",  831, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "300.15", "300.15", "Parameter measurement temperature" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "cgso",  832, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F/m", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "1.03594e-09", "1.03594e-09", "Gate-source overlap capacitance per width" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "cgdo",  833, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F/m", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "1.03594e-09", "1.03594e-09", "Gate-drain overlap capacitance per width" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "cgbo",  834, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F/m", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0", "0", "Gate-bulk overlap capacitance per length" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "xpart",  835, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Channel charge partitioning" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "delta",  156, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.01", "0.01", "Effective Vds parameter" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rsh",  836, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω/m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Source-drain sheet resistance" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rdsw",  157, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "200", "200", "Source-drain resistance per width" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rdswmin",  251, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Source-drain resistance per width at high Vg" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rsw",  252, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "100", "100", "Source resistance per width" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rdw",  253, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "100", "100", "Drain resistance per width" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rdwmin",  254, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Drain resistance per width at high Vg" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rswmin",  255, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Source resistance per width at high Vg" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "prwg",  179, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Gate-bias effect on parasitic resistance" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "prwb",  180, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body-effect on parasitic resistance" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "prt",  158, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient of parasitic resistance" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "eta0",  161, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.08", "0.08", "Subthreshold region DIBL coefficient" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "etab",  162, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "-0.07", "-0.07", "Subthreshold region DIBL coefficient" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pclm",  163, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "1/V", SIM_MODEL::PARAM::CATEGORY::DC, "1.3", "1.3", "Channel length modulation Coefficient" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pdiblc1",  164, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.39", "0.39", "Drain-induced barrier lowering coefficient" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pdiblc2",  165, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.0086", "0.0086", "Drain-induced barrier lowering coefficient" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pdiblcb",  178, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body-effect on drain-induced barrier lowering" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "fprout",  245, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Rout degradation coefficient for pocket devices" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pdits",  239, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Coefficient for drain-induced Vth shifts" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pditsl",  241, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of drain-induced Vth shifts" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pditsd",  240, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Vds dependence of drain-induced Vth shifts" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pscbe1",  166, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "4.24e+08", "4.24e+08", "Substrate current body-effect coefficient" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pscbe2",  167, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "1e-05", "1e-05", "Substrate current body-effect coefficient" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pvag",  168, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate dependence of output resistance parameter" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "jss",  837, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A/m²", SIM_MODEL::PARAM::CATEGORY::DC, "0.0001", "0.0001", "Bottom source junction reverse saturation current density" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "jsws",  878, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A/m²", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Isolation edge sidewall source junction reverse saturation current density" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "jswgs",  280, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A/m²", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate edge source junction reverse saturation current density" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pbs",  838, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Source junction built-in potential" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "njs",  873, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Source junction emission coefficient" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "xtis",  874, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "3", "3", "Source junction current temperature exponent" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "mjs",  839, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0.5", "0.5", "Source bottom junction capacitance grading coefficient" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pbsws",  840, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "1", "1", "Source sidewall junction capacitance built in potential" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "mjsws",  841, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0.33", "0.33", "Source sidewall junction capacitance grading coefficient" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pbswgs",  875, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "1", "1", "Source (gate side) sidewall junction capacitance built in potential" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "mjswgs",  876, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0.33", "0.33", "Source (gate side) sidewall junction capacitance grading coefficient" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "cjs",  842, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0.0005", "0.0005", "Source bottom junction capacitance per unit area" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "cjsws",  843, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "5e-10", "5e-10", "Source sidewall junction capacitance per unit periphery" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "cjswgs",  877, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "5e-10", "5e-10", "Source (gate side) sidewall junction capacitance per unit width" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "jsd",  886, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A/m²", SIM_MODEL::PARAM::CATEGORY::DC, "0.0001", "0.0001", "Bottom drain junction reverse saturation current density" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "jswd",  898, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A/m²", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Isolation edge sidewall drain junction reverse saturation current density" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "jswgd",  281, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A/m²", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate edge drain junction reverse saturation current density" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pbd",  887, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Drain junction built-in potential" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "njd",  893, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Drain junction emission coefficient" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "xtid",  894, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "3", "3", "Drainjunction current temperature exponent" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "mjd",  888, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0.5", "0.5", "Drain bottom junction capacitance grading coefficient" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pbswd",  889, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "1", "1", "Drain sidewall junction capacitance built in potential" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "mjswd",  890, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0.33", "0.33", "Drain sidewall junction capacitance grading coefficient" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pbswgd",  895, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "1", "1", "Drain (gate side) sidewall junction capacitance built in potential" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "mjswgd",  896, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0.33", "0.33", "Drain (gate side) sidewall junction capacitance grading coefficient" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "cjd",  891, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0.0005", "0.0005", "Drain bottom junction capacitance per unit area" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "cjswd",  892, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "5e-10", "5e-10", "Drain sidewall junction capacitance per unit periphery" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "cjswgd",  897, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "5e-10", "5e-10", "Drain (gate side) sidewall junction capacitance per unit width" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "vfbcv",  194, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "-1", "-1", "Flat Band Voltage parameter for capmod=0 only" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "vfb",  200, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "-1", "-1", "Flat Band Voltage" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "tpb",  205, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient of pb" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "tcj",  202, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient of cj" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "tpbsw",  206, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient of pbsw" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "tcjsw",  203, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient of cjsw" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "tpbswg",  207, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient of pbswg" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "tcjswg",  204, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient of cjswg" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "acde",  195, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Exponential coefficient for finite charge thickness" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "moin",  196, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "15", "15", "Coefficient for gate-bias dependent surface potential" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "noff",  197, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "C-V turn-on/off parameter" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "voffcv",  208, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "C-V lateral-shift parameter" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "dmcg",  215, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Distance of Mid-Contact to Gate edge" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "dmci",  216, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Distance of Mid-Contact to Isolation" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "dmdg",  217, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Distance of Mid-Diffusion to Gate edge" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "dmcgt",  258, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Distance of Mid-Contact to Gate edge in Test structures" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "xgw_",  218, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Distance from gate contact center to device edge" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "xgl",  219, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Variation in Ldrawn" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rshg",  220, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω/m", SIM_MODEL::PARAM::CATEGORY::DC, "0.1", "0.1", "Gate sheet resistance" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ngcon_",  221, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Number of gate contacts" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "xrcrg1",  232, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "12", "12", "First fitting parameter the bias-dependent Rg" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "xrcrg2",  233, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Second fitting parameter the bias-dependent Rg" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lambda",  282, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m/s", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Velocity overshoot parameter" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "vtl",  283, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m/s", SIM_MODEL::PARAM::CATEGORY::DC, "200000", "200000", "thermal velocity" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lc",  284, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "5e-09", "5e-09", "back scattering parameter" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "xn",  285, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "3", "3", "back scattering parameter" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "vfbsdoff",  288, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "S/D flatband voltage offset" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "tvfbsdoff",  295, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature parameter for vfbsdoff" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "tvoff",  294, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature parameter for voff" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "tnfactor",  1256, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature parameter for nfactor" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "teta0",  1257, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature parameter for eta0" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "tvoffcv",  1258, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature parameter for tvoffcv" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lintnoi",  289, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "0", "0", "lint offset for noise calculation" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lint",  849, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length reduction parameter" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ll",  850, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length reduction parameter" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "llc",  879, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length reduction parameter for CV" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lln",  851, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Length reduction parameter" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lw",  852, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length reduction parameter" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lwc",  880, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length reduction parameter for CV" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lwn",  853, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Length reduction parameter" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lwl",  854, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length reduction parameter" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lwlc",  881, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length reduction parameter for CV" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lmin",  855, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Minimum length for the model" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lmax",  856, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Maximum length for the model" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wr",  169, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Width dependence of rds" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wint",  857, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width reduction parameter" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "dwg",  170, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width reduction parameter" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "dwb",  171, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width reduction parameter" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wl",  858, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width reduction parameter" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wlc",  882, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width reduction parameter for CV" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wln",  859, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Width reduction parameter" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ww",  860, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width reduction parameter" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wwc",  883, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width reduction parameter for CV" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wwn",  861, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Width reduction parameter" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wwl",  862, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width reduction parameter" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wwlc",  884, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width reduction parameter for CV" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wmin",  863, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Minimum width for the model" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wmax",  864, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Maximum width for the model" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "b0",  172, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Abulk narrow width parameter" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "b1",  173, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Abulk narrow width parameter" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "cgsl",  186, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "New C-V model parameter" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "cgdl",  187, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "New C-V model parameter" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ckappas",  188, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.6", "0.6", "S/G overlap C-V parameter" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ckappad",  257, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.6", "0.6", "D/G overlap C-V parameter" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "cf",  189, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "1.07725e-10", "1.07725e-10", "Fringe capacitance parameter" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "clc",  190, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1e-07", "1e-07", "Vdsat parameter for C-V model" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "cle",  191, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.6", "0.6", "Vdsat parameter for C-V model" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "dwc",  865, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Delta W for C-V model" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "dlc",  866, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Delta L for C-V model" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "xw",  868, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "W offset for channel width due to mask/etch effect" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "xl",  867, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "L offset for channel length due to mask/etch effect" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "dlcig",  899, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Delta L for Ig model" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "dlcigd",  1244, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Delta L for Ig model drain side" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "dwj",  885, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Delta W for S/D junctions" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "alpha0",  174, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "substrate current model parameter" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "alpha1",  199, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "substrate current model parameter" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "beta0",  175, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "substrate current model parameter" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "agidl",  222, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Pre-exponential constant for GIDL" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "bgidl",  223, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "2.3e+09", "2.3e+09", "Exponential constant for GIDL" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "cgidl",  249, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.5", "0.5", "Parameter for body-bias dependence of GIDL" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rgidl",  446, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "GIDL vg parameter" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "kgidl",  445, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "GIDL vb parameter" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "fgidl",  444, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "GIDL vb parameter" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "egidl",  224, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.8", "0.8", "Fitting parameter for Bandbending" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "agisl",  1200, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Pre-exponential constant for GISL" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "bgisl",  1201, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "2.3e+09", "2.3e+09", "Exponential constant for GISL" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "cgisl",  1203, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.5", "0.5", "Parameter for body-bias dependence of GISL" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rgisl",  449, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "GISL vg parameter" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "kgisl",  448, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "GISL vb parameter" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "fgisl",  447, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "GISL vb parameter" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "egisl",  1202, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.8", "0.8", "Fitting parameter for Bandbending" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "aigc",  259, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.0136", "0.0098", "Parameter for Igc" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "bigc",  260, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.00171", "0.000759", "Parameter for Igc" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "cigc",  261, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.075", "0.03", "Parameter for Igc" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "aigsd",  277, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.0136", "0.0098", "Parameter for Igs,d" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "bigsd",  278, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.00171", "0.000759", "Parameter for Igs,d" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "cigsd",  279, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.075", "0.03", "Parameter for Igs,d" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "aigs",  1220, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.0136", "0.0098", "Parameter for Igs" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "bigs",  1221, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.00171", "0.000759", "Parameter for Igs" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "cigs",  1222, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.075", "0.03", "Parameter for Igs" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "aigd",  1232, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.0136", "0.0098", "Parameter for Igd" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "bigd",  1233, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.00171", "0.000759", "Parameter for Igd" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "cigd",  1234, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.075", "0.03", "Parameter for Igd" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "aigbacc",  262, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.0136", "0.0136", "Parameter for Igb" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "bigbacc",  263, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.00171", "0.00171", "Parameter for Igb" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "cigbacc",  264, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.075", "0.075", "Parameter for Igb" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "aigbinv",  265, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.0111", "0.0111", "Parameter for Igb" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "bigbinv",  266, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.000949", "0.000949", "Parameter for Igb" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "cigbinv",  267, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.006", "0.006", "Parameter for Igb" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "nigc",  268, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Parameter for Igc slope" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "nigbinv",  270, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "3", "3", "Parameter for Igbinv slope" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "nigbacc",  269, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Parameter for Igbacc slope" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ntox",  271, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Exponent for Tox ratio" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "eigbinv",  273, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1.1", "1.1", "Parameter for the Si bandgap for Igbinv" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pigcd",  274, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Parameter for Igc partition" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "poxedge",  275, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Factor for the gate edge Tox" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ijthdfwd",  198, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0.1", "0.1", "Forward drain diode forward limiting current" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ijthsfwd",  225, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0.1", "0.1", "Forward source diode forward limiting current" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ijthdrev",  236, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0.1", "0.1", "Reverse drain diode forward limiting current" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ijthsrev",  235, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0.1", "0.1", "Reverse source diode forward limiting current" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "xjbvd",  226, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Fitting parameter for drain diode breakdown current" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "xjbvs",  227, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Fitting parameter for source diode breakdown current" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "bvd",  228, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "10", "10", "Drain diode breakdown voltage" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "bvs",  229, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "10", "10", "Source diode breakdown voltage" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "jtss",  900, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A/m²", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Source bottom trap-assisted saturation current density" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "jtsd",  901, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A/m²", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Drain bottom trap-assisted saturation current density" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "jtssws",  902, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A/m²", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Source STI sidewall trap-assisted saturation current density" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "jtsswd",  903, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A/m²", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Drain STI sidewall trap-assisted saturation current density" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "jtsswgs",  904, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A/m²", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Source gate-edge sidewall trap-assisted saturation current density" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "jtsswgd",  905, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A/m²", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Drain gate-edge sidewall trap-assisted saturation current density" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "jtweff",  928, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "TAT current width dependence" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "njts",  906, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "20", "20", "Non-ideality factor for bottom junction" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "njtssw",  907, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "20", "20", "Non-ideality factor for STI sidewall junction" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "njtsswg",  908, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "20", "20", "Non-ideality factor for gate-edge sidewall junction" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "njtsd",  1250, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "20", "20", "Non-ideality factor for bottom junction drain side" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "njtsswd",  1251, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "20", "20", "Non-ideality factor for STI sidewall junction drain side" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "njtsswgd",  1252, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "20", "20", "Non-ideality factor for gate-edge sidewall junction drain side" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "xtss",  909, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0.02", "0.02", "Power dependence of JTSS on temperature" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "xtsd",  910, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0.02", "0.02", "Power dependence of JTSD on temperature" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "xtssws",  911, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0.02", "0.02", "Power dependence of JTSSWS on temperature" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "xtsswd",  912, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0.02", "0.02", "Power dependence of JTSSWD on temperature" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "xtsswgs",  913, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0.02", "0.02", "Power dependence of JTSSWGS on temperature" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "xtsswgd",  914, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0.02", "0.02", "Power dependence of JTSSWGD on temperature" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "tnjts",  915, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient for NJTS" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "tnjtssw",  916, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient for NJTSSW" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "tnjtsswg",  917, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient for NJTSSWG" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "tnjtsd",  1253, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient for NJTSD" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "tnjtsswd",  1254, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient for NJTSSWD" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "tnjtsswgd",  1255, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient for NJTSSWGD" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "vtss",  918, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "10", "10", "Source bottom trap-assisted voltage dependent parameter" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "vtsd",  919, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "10", "10", "Drain bottom trap-assisted voltage dependent parameter" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "vtssws",  920, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "10", "10", "Source STI sidewall trap-assisted voltage dependent parameter" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "vtsswd",  921, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "10", "10", "Drain STI sidewall trap-assisted voltage dependent parameter" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "vtsswgs",  922, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "10", "10", "Source gate-edge sidewall trap-assisted voltage dependent parameter" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "vtsswgd",  923, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "10", "10", "Drain gate-edge sidewall trap-assisted voltage dependent parameter" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "gbmin",  209, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1e-12", "1e-12", "Minimum body conductance" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rbdb",  210, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "50", "50", "Resistance between bNode and dbNode" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rbpb",  212, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "50", "50", "Resistance between bNodePrime and bNode" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rbsb",  211, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "50", "50", "Resistance between bNode and sbNode" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rbps",  213, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "50", "50", "Resistance between bNodePrime and sbNode" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rbpd",  214, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "50", "50", "Resistance between bNodePrime and bNode" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rbps0",  1101, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "50", "50", "Body resistance RBPS scaling" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rbpsl",  1102, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body resistance RBPS L scaling" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rbpsw",  1103, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body resistance RBPS W scaling" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rbpsnf",  1104, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body resistance RBPS NF scaling" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rbpd0",  1105, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "50", "50", "Body resistance RBPD scaling" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rbpdl",  1106, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body resistance RBPD L scaling" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rbpdw",  1107, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body resistance RBPD W scaling" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rbpdnf",  1108, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body resistance RBPD NF scaling" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rbpbx0",  1109, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "100", "100", "Body resistance RBPBX  scaling" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rbpbxl",  1110, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body resistance RBPBX L scaling" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rbpbxw",  1111, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body resistance RBPBX W scaling" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rbpbxnf",  1112, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body resistance RBPBX NF scaling" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rbpby0",  1113, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "100", "100", "Body resistance RBPBY  scaling" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rbpbyl",  1114, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body resistance RBPBY L scaling" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rbpbyw",  1115, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body resistance RBPBY W scaling" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rbpbynf",  1116, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body resistance RBPBY NF scaling" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rbsbx0",  1117, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "100", "100", "Body resistance RBSBX  scaling" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rbsby0",  1118, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "100", "100", "Body resistance RBSBY  scaling" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rbdbx0",  1119, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "100", "100", "Body resistance RBDBX  scaling" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rbdby0",  1120, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "100", "100", "Body resistance RBDBY  scaling" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rbsdbxl",  1121, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body resistance RBSDBX L scaling" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rbsdbxw",  1122, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body resistance RBSDBX W scaling" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rbsdbxnf",  1123, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body resistance RBSDBX NF scaling" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rbsdbyl",  1124, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body resistance RBSDBY L scaling" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rbsdbyw",  1125, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body resistance RBSDBY W scaling" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rbsdbynf",  1126, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body resistance RBSDBY NF scaling" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lcdsc",  301, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cdsc" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lcdscb",  302, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cdscb" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lcdscd",  377, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cdscd" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lcit",  303, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cit" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lnfactor",  304, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nfactor" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lxj",  305, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of xj" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lvsat",  306, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vsat" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lat",  307, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of at" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "la0",  308, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of a0" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lags",  378, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ags" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "la1",  309, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of a1" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "la2",  310, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of a2" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lketa",  311, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of keta" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lnsub",  312, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nsub" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lndep",  313, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ndep" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lnsd",  414, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nsd" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lphin",  411, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of phin" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lngate",  315, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ngate" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lgamma1",  316, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of gamma1" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lgamma2",  317, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of gamma2" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lvbx",  318, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vbx" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lvbm",  320, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vbm" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lxt",  322, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of xt" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lk1",  325, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of k1" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lkt1",  326, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of kt1" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lkt1l",  327, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of kt1l" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lkt2",  329, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of kt2" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lk2",  328, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of k2" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lk3",  330, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of k3" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lk3b",  331, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of k3b" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lw0",  332, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of w0" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ldvtp0",  408, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dvtp0" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ldvtp1",  409, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dvtp1" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ldvtp2",  472, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dvtp2" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ldvtp3",  473, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dvtp3" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ldvtp4",  474, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dvtp4" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ldvtp5",  475, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dvtp5" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "llpe0",  333, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of lpe0" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "llpeb",  407, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of lpeb" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ldvt0",  334, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dvt0" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ldvt1",  335, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dvt1" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ldvt2",  336, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dvt2" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ldvt0w",  337, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dvt0w" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ldvt1w",  338, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dvt1w" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ldvt2w",  339, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dvt2w" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ldrout",  340, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of drout" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ldsub",  341, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dsub" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lvth0",  342, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vth0" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lvtho",  342, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "n.a." );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lua",  343, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ua" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lua1",  344, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ua1" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lub",  345, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ub" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lub1",  346, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ub1" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "luc",  347, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of uc" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "luc1",  348, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of uc1" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lud",  439, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ud" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lud1",  440, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ud1" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lup",  441, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of up" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "llp",  442, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of lp" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lu0",  349, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of u0" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lute",  350, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ute" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lucste",  69, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ucste" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lvoff",  351, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of voff" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lminv",  403, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of minv" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lminvcv",  443, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of minvcv" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ldelta",  352, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of delta" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lrdsw",  353, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of rdsw" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lrsw",  412, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of rsw" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lrdw",  413, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of rdw" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lprwg",  375, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of prwg" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lprwb",  376, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of prwb" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lprt",  354, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of prt" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "leta0",  357, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of eta0" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "letab",  358, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "-0", "-0", "Length dependence of etab" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lpclm",  359, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of pclm" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lpdiblc1",  360, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of pdiblc1" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lpdiblc2",  361, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of pdiblc2" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lpdiblcb",  374, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of pdiblcb" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lfprout",  406, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of pdiblcb" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lpdits",  404, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of pdits" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lpditsd",  405, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of pditsd" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lpscbe1",  362, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of pscbe1" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lpscbe2",  363, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of pscbe2" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lpvag",  364, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of pvag" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lwr",  365, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of wr" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ldwg",  366, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dwg" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ldwb",  367, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dwb" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lb0",  368, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of b0" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lb1",  369, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of b1" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lcgsl",  383, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cgsl" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lcgdl",  384, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cgdl" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lckappas",  385, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ckappas" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lckappad",  415, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ckappad" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lcf",  386, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cf" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lclc",  387, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of clc" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lcle",  388, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cle" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lalpha0",  370, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of alpha0" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lalpha1",  394, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of alpha1" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lbeta0",  371, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of beta0" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lagidl",  397, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of agidl" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lbgidl",  398, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of bgidl" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lcgidl",  410, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cgidl" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lrgidl",  452, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of rgidl" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lkgidl",  451, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of kgidl" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lfgidl",  450, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of fgidl" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "legidl",  399, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of egidl" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lagisl",  1204, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of agisl" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lbgisl",  1205, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of bgisl" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lcgisl",  1207, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cgisl" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lrgisl",  455, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of rgisl" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lkgisl",  454, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of kgisl" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lfgisl",  453, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of fgisl" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "legisl",  1206, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of egisl" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "laigc",  416, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of aigc" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lbigc",  417, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of bigc" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lcigc",  418, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cigc" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "laigsd",  432, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of aigsd" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lbigsd",  433, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of bigsd" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lcigsd",  434, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cigsd" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "laigs",  1223, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of aigs" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lbigs",  1224, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of bigs" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lcigs",  1225, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cigs" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "laigd",  1235, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of aigd" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lbigd",  1236, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of bigd" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lcigd",  1237, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cigd" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "laigbacc",  419, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of aigbacc" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lbigbacc",  420, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of bigbacc" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lcigbacc",  421, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cigbacc" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "laigbinv",  422, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of aigbinv" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lbigbinv",  423, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of bigbinv" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lcigbinv",  424, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cigbinv" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lnigc",  425, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nigc" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lnigbinv",  427, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nigbinv" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lnigbacc",  426, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nigbacc" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lntox",  428, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ntox" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "leigbinv",  429, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence for eigbinv" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lpigcd",  430, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence for pigcd" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lpoxedge",  431, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence for poxedge" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lvfbcv",  389, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vfbcv" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lvfb",  395, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vfb" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lacde",  390, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of acde" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lmoin",  391, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of moin" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lnoff",  392, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of noff" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lvoffcv",  396, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of voffcv" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lxrcrg1",  400, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of xrcrg1" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lxrcrg2",  401, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of xrcrg2" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "llambda",  435, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of lambda" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lvtl",  436, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vtl" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lxn",  437, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of xn" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "leu",  402, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of eu" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lucs",  73, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of lucs" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lvfbsdoff",  438, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vfbsdoff" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ltvfbsdoff",  1052, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of tvfbsdoff" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ltvoff",  1051, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of tvoff" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ltnfactor",  1260, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of tnfactor" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lteta0",  1261, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of teta0" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ltvoffcv",  1262, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of tvoffcv" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wcdsc",  481, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cdsc" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wcdscb",  482, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cdscb" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wcdscd",  557, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cdscd" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wcit",  483, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cit" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wnfactor",  484, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nfactor" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wxj",  485, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of xj" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wvsat",  486, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vsat" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wat",  487, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of at" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wa0",  488, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of a0" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wags",  558, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ags" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wa1",  489, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of a1" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wa2",  490, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of a2" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wketa",  491, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of keta" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wnsub",  492, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nsub" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wndep",  493, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ndep" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wnsd",  594, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nsd" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wphin",  591, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of phin" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wngate",  495, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ngate" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wgamma1",  496, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of gamma1" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wgamma2",  497, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of gamma2" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wvbx",  498, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vbx" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wvbm",  500, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vbm" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wxt",  502, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of xt" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wk1",  505, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of k1" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wkt1",  506, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of kt1" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wkt1l",  507, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of kt1l" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wkt2",  509, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of kt2" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wk2",  508, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of k2" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wk3",  510, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of k3" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wk3b",  511, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of k3b" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ww0",  512, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of w0" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wdvtp0",  588, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dvtp0" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wdvtp1",  589, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dvtp1" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wdvtp2",  476, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dvtp2" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wdvtp3",  477, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dvtp3" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wdvtp4",  478, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dvtp4" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wdvtp5",  479, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dvtp5" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wlpe0",  513, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of lpe0" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wlpeb",  587, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of lpeb" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wdvt0",  514, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dvt0" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wdvt1",  515, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dvt1" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wdvt2",  516, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dvt2" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wdvt0w",  517, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dvt0w" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wdvt1w",  518, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dvt1w" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wdvt2w",  519, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dvt2w" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wdrout",  520, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of drout" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wdsub",  521, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dsub" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wvth0",  522, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vth0" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wvtho",  522, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "n.a." );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wua",  523, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ua" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wua1",  524, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ua1" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wub",  525, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ub" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wub1",  526, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ub1" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wuc",  527, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of uc" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wuc1",  528, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of uc1" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wud",  619, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ud" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wud1",  620, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ud1" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wup",  621, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of up" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wlp",  622, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of lp" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wu0",  529, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of u0" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wute",  530, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ute" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wucste",  70, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ucste" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wvoff",  531, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of voff" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wminv",  583, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of minv" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wminvcv",  623, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of minvcv" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wdelta",  532, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of delta" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wrdsw",  533, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of rdsw" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wrsw",  592, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of rsw" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wrdw",  593, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of rdw" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wprwg",  555, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of prwg" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wprwb",  556, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of prwb" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wprt",  534, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of prt" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "weta0",  537, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of eta0" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wetab",  538, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of etab" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wpclm",  539, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of pclm" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wpdiblc1",  540, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of pdiblc1" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wpdiblc2",  541, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of pdiblc2" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wpdiblcb",  554, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of pdiblcb" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wfprout",  586, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of pdiblcb" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wpdits",  584, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of pdits" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wpditsd",  585, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of pditsd" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wpscbe1",  542, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of pscbe1" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wpscbe2",  543, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of pscbe2" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wpvag",  544, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of pvag" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wwr",  545, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of wr" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wdwg",  546, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dwg" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wdwb",  547, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dwb" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wb0",  548, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of b0" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wb1",  549, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of b1" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wcgsl",  563, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cgsl" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wcgdl",  564, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cgdl" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wckappas",  565, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ckappas" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wckappad",  595, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ckappad" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wcf",  566, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cf" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wclc",  567, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of clc" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wcle",  568, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cle" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "walpha0",  550, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of alpha0" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "walpha1",  574, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of alpha1" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wbeta0",  551, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of beta0" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wagidl",  577, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of agidl" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wbgidl",  578, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of bgidl" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wcgidl",  590, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cgidl" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wrgidl",  458, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of rgidl" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wkgidl",  457, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of kgidl" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wfgidl",  456, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of fgidl" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wegidl",  579, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of egidl" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wagisl",  1208, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of agisl" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wbgisl",  1209, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of bgisl" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wcgisl",  1211, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cgisl" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wrgisl",  461, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of rgisl" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wkgisl",  460, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of kgisl" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wfgisl",  459, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of fgisl" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wegisl",  1210, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of egisl" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "waigc",  596, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of aigc" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wbigc",  597, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of bigc" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wcigc",  598, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cigc" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "waigsd",  612, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of aigsd" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wbigsd",  613, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of bigsd" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wcigsd",  614, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cigsd" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "waigs",  1226, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of aigs" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wbigs",  1227, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of bigs" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wcigs",  1228, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cigs" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "waigd",  1238, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of aigd" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wbigd",  1239, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of bigd" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wcigd",  1240, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cigd" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "waigbacc",  599, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of aigbacc" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wbigbacc",  600, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of bigbacc" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wcigbacc",  601, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cigbacc" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "waigbinv",  602, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of aigbinv" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wbigbinv",  603, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of bigbinv" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wcigbinv",  604, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cigbinv" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wnigc",  605, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nigc" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wnigbinv",  607, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nigbinv" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wnigbacc",  606, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nigbacc" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wntox",  608, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ntox" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "weigbinv",  609, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence for eigbinv" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wpigcd",  610, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence for pigcd" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wpoxedge",  611, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence for poxedge" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wvfbcv",  569, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vfbcv" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wvfb",  575, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vfb" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wacde",  570, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of acde" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wmoin",  571, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of moin" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wnoff",  572, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of noff" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wvoffcv",  576, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of voffcv" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wxrcrg1",  580, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of xrcrg1" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wxrcrg2",  581, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of xrcrg2" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wlambda",  615, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of lambda" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wvtl",  616, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vtl" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wxn",  617, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of xn" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "weu",  582, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of eu" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wucs",  74, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ucs" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wvfbsdoff",  618, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vfbsdoff" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wtvfbsdoff",  1054, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of tvfbsdoff" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wtvoff",  1053, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of tvoff" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wtnfactor",  1264, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of tnfactor" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wteta0",  1265, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of teta0" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wtvoffcv",  1266, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of tvoffcv" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pcdsc",  661, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cdsc" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pcdscb",  662, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cdscb" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pcdscd",  737, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cdscd" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pcit",  663, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cit" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pnfactor",  664, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nfactor" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pxj",  665, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of xj" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pvsat",  666, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vsat" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pat",  667, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of at" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pa0",  668, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of a0" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pags",  738, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ags" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pa1",  669, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of a1" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pa2",  670, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of a2" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pketa",  671, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of keta" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pnsub",  672, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nsub" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pndep",  673, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ndep" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pnsd",  774, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nsd" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pphin",  771, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of phin" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pngate",  675, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ngate" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pgamma1",  676, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of gamma1" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pgamma2",  677, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of gamma2" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pvbx",  678, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vbx" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pvbm",  680, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vbm" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pxt",  682, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of xt" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pk1",  685, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of k1" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pkt1",  686, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of kt1" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pkt1l",  687, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of kt1l" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pkt2",  689, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of kt2" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pk2",  688, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of k2" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pk3",  690, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of k3" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pk3b",  691, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of k3b" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pw0",  692, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of w0" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pdvtp0",  768, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dvtp0" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pdvtp1",  769, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dvtp1" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pdvtp2",  480, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dvtp2" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pdvtp3",  298, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dvtp3" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pdvtp4",  299, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dvtp4" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pdvtp5",  300, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dvtp5" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "plpe0",  693, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of lpe0" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "plpeb",  767, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of lpeb" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pdvt0",  694, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dvt0" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pdvt1",  695, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dvt1" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pdvt2",  696, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dvt2" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pdvt0w",  697, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dvt0w" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pdvt1w",  698, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dvt1w" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pdvt2w",  699, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dvt2w" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pdrout",  700, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of drout" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pdsub",  701, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dsub" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pvth0",  702, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vth0" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pvtho",  702, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "n.a." );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pua",  703, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ua" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pua1",  704, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ua1" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pub",  705, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ub" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pub1",  706, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ub1" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "puc",  707, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of uc" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "puc1",  708, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of uc1" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pud",  924, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ud" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pud1",  925, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ud1" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pup",  926, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of up" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "plp",  927, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of lp" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pu0",  709, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of u0" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pute",  710, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ute" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pucste",  71, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ucste" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pvoff",  711, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of voff" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pminv",  763, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of minv" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pminvcv",  823, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of minvcv" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pdelta",  712, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of delta" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "prdsw",  713, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of rdsw" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "prsw",  772, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of rsw" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "prdw",  773, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of rdw" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pprwg",  735, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of prwg" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pprwb",  736, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of prwb" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pprt",  714, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of prt" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "peta0",  717, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of eta0" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "petab",  718, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of etab" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ppclm",  719, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of pclm" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ppdiblc1",  720, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of pdiblc1" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ppdiblc2",  721, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of pdiblc2" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ppdiblcb",  734, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of pdiblcb" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pfprout",  766, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of pdiblcb" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ppdits",  764, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of pdits" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ppditsd",  765, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of pditsd" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ppscbe1",  722, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of pscbe1" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ppscbe2",  723, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of pscbe2" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ppvag",  724, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of pvag" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pwr",  725, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of wr" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pdwg",  726, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dwg" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pdwb",  727, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dwb" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pb0",  728, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of b0" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pb1",  729, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of b1" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pcgsl",  743, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cgsl" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pcgdl",  744, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cgdl" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pckappas",  745, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ckappas" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pckappad",  775, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ckappad" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pcf",  746, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cf" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pclc",  747, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of clc" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pcle",  748, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cle" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "palpha0",  730, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of alpha0" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "palpha1",  754, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of alpha1" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pbeta0",  731, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of beta0" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pagidl",  757, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of agidl" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pbgidl",  758, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of bgidl" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pcgidl",  770, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cgidl" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "prgidl",  464, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of rgidl" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pkgidl",  463, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of kgidl" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pfgidl",  462, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of fgidl" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pegidl",  759, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of egidl" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pagisl",  1212, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of agisl" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pbgisl",  1213, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of bgisl" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pcgisl",  1215, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cgisl" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pegisl",  1214, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of egisl" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "prgisl",  467, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of rgisl" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pkgisl",  466, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of kgisl" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pfgisl",  465, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of fgisl" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "paigc",  776, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of aigc" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pbigc",  777, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of bigc" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pcigc",  778, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cigc" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "paigsd",  792, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of aigsd" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pbigsd",  793, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of bigsd" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pcigsd",  794, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cigsd" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "paigs",  1229, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of aigs" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pbigs",  1230, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of bigs" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pcigs",  1231, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cigs" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "paigd",  1241, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of aigd" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pbigd",  1242, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of bigd" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pcigd",  1243, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cigd" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "paigbacc",  779, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of aigbacc" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pbigbacc",  780, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of bigbacc" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pcigbacc",  781, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cigbacc" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "paigbinv",  782, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of aigbinv" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pbigbinv",  783, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of bigbinv" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pcigbinv",  784, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cigbinv" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pnigc",  785, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nigc" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pnigbinv",  787, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nigbinv" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pnigbacc",  786, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nigbacc" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pntox",  788, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ntox" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "peigbinv",  789, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence for eigbinv" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ppigcd",  790, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence for pigcd" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ppoxedge",  791, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence for poxedge" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pvfbcv",  749, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vfbcv" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pvfb",  755, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vfb" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pacde",  750, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of acde" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pmoin",  751, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of moin" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pnoff",  752, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of noff" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pvoffcv",  756, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of voffcv" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pxrcrg1",  760, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of xrcrg1" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pxrcrg2",  761, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of xrcrg2" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "plambda",  825, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of lambda" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pvtl",  826, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vtl" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pxn",  827, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of xn" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "peu",  762, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of eu" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pucs",  75, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ucs" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pvfbsdoff",  828, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vfbsdoff" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ptvfbsdoff",  1056, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of tvfbsdoff" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ptvoff",  1055, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of tvoff" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ptnfactor",  1268, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of tnfactor" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pteta0",  1269, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of teta0" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ptvoffcv",  1270, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of tvoffcv" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "saref",  795, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1e-06", "1e-06", "Reference distance between OD edge to poly of one side" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "sbref",  796, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1e-06", "1e-06", "Reference distance between OD edge to poly of the other side" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wlod",  811, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width parameter for stress effect" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ku0",  797, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Mobility degradation/enhancement coefficient for LOD" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "kvsat",  798, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m/s", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Saturation velocity degradation/enhancement parameter for LOD" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "kvth0",  807, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Threshold degradation/enhancement parameter for LOD" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "tku0",  799, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient of KU0" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "llodku0",  800, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length parameter for u0 LOD effect" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wlodku0",  801, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width parameter for u0 LOD effect" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "llodvth",  802, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length parameter for vth LOD effect" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wlodvth",  803, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width parameter for vth LOD effect" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lku0",  804, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ku0" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wku0",  805, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ku0" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pku0",  806, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ku0" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lkvth0",  808, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of kvth0" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wkvth0",  809, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of kvth0" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pkvth0",  810, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of kvth0" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "stk2",  812, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "K2 shift factor related to stress effect on vth" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lodk2",  813, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "K2 shift modification factor for stress effect" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "steta0",  814, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "eta0 shift factor related to stress effect on vth" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lodeta0",  815, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "eta0 shift modification factor for stress effect" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "web",  816, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Coefficient for SCB" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wec",  817, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Coefficient for SCC" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "kvth0we",  818, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Threshold shift factor for well proximity effect" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "k2we",  819, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "K2 shift factor for well proximity effect" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ku0we",  820, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Mobility degradation factor for well proximity effect" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "scref",  821, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1e-06", "1e-06", "Reference distance to calculate SCA, SCB and SCC" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wpemod",  822, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Flag for WPE model (WPEMOD=1 to activate this model)" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lkvth0we",  1061, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of kvth0we" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lk2we",  1062, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of k2we" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "lku0we",  1063, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ku0we" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wkvth0we",  1064, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of kvth0we" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wk2we",  1065, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of k2we" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "wku0we",  1066, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ku0we" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pkvth0we",  1067, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of kvth0we" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pk2we",  1068, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of k2we" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pku0we",  1069, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ku0we" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "noia",  846, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "6.25e+41", "6.188e+40", "Flicker noise parameter" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "noib",  847, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "3.125e+26", "1.5e+25", "Flicker noise parameter" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "noic",  848, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "8.75e+09", "8.75e+09", "Flicker noise parameter" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "tnoia",  242, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "1.5", "1.5", "Thermal noise parameter" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "tnoib",  243, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "3.5", "3.5", "Thermal noise parameter" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "tnoic",  1272, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "0", "0", "Thermal noise parameter" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rnoia",  286, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "0.577", "0.577", "Thermal noise coefficient" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rnoib",  287, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "0.5164", "0.5164", "Thermal noise coefficient" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "rnoic",  1273, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "0.395", "0.395", "Thermal noise coefficient" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ntnoi",  244, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "1", "1", "Thermal noise parameter" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "em",  869, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "4.1e+07", "4.1e+07", "Flicker noise parameter" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "ef",  870, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "1", "1", "Flicker noise frequency exponent" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "af",  871, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "1", "1", "Flicker noise exponent" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "kf",  872, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "0", "0", "Flicker noise coefficient" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "vgs_max",  1301, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage G-S branch" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "vgd_max",  1302, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage G-D branch" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "vgb_max",  1303, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage G-B branch" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "vds_max",  1304, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage D-S branch" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "vbs_max",  1305, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage B-S branch" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "vbd_max",  1306, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage B-D branch" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "vgsr_max",  1307, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage G-S branch" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "vgdr_max",  1308, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage G-D branch" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "vgbr_max",  1309, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage G-B branch" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "vbsr_max",  1310, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage B-S branch" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "vbdr_max",  1311, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage B-D branch" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "nmos",  844, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_BOOL, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Flag to indicate NMOS" );
    modelInfos[MODEL_TYPE::BSIM4].modelParams.emplace_back( "pmos",  845, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_BOOL, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Flag to indicate PMOS" );
    // Instance parameters
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "l",  2, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Length", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "w",  1, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Width", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "m",  38, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Separate Parallel multiplier", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "nf",  19, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Number of fingers", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "sa",  28, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "distance between  OD edge to poly of one side", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "sb",  29, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "distance between  OD edge to poly of the other side", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "sd",  30, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "distance between neighbour fingers", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "sca",  34, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Integral of the first distribution function for scattered well dopant", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "scb",  35, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Integral of the second distribution function for scattered well dopant", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "scc",  36, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Integral of the third distribution function for scattered well dopant", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "sc",  37, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Distance to a single well edge", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "min",  20, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Minimize either D or S", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "ad",  4, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Drain area", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "as",  3, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Source area", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "pd",  6, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Drain perimeter", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "ps",  5, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Source perimeter", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "nrd",  8, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Number of squares in drain", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "nrs",  7, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Number of squares in source", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "off",  9, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_BOOL, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Device is initially off", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "rbdb_",  23, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "50", "50", "Body resistance", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "rbsb_",  24, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "50", "50", "Body resistance", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "rbpb_",  25, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "50", "50", "Body resistance", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "rbps_",  26, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "50", "50", "Body resistance", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "rbpd_",  27, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "50", "50", "Body resistance", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "delvto",  31, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Zero bias threshold voltage variation", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "delvt0",  31, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "n.a.", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "mulu0",  39, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Low field mobility multiplier", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "xgw",  32, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "Distance from gate contact center to device edge", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "ngcon",  33, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "1", "1", "Number of gate contacts", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "wnflag",  40, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "W/NF device flag for bin selection", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "trnqsmod",  14, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "Transient NQS model selector", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "acnqsmod",  22, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "AC NQS model selector", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "rbodymod",  15, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "Distributed body R model selector", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "rgatemod",  16, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "Gate resistance model selector", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "geomod",  17, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "Geometry dependent parasitics model selector", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "rgeomod",  18, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "S/D resistance and contact model selector", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "ic",  10, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_FLOAT_VECTOR, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Vector of DS,GS,BS initial voltages", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "gmbs",  966, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gmb", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "gm",  964, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gm", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "gds",  965, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gds", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "vdsat",  987, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Vdsat", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "vth",  986, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Vth", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "id",  961, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Ids", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "ibd",  963, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Ibd", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "ibs",  962, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Ibs", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "gbd",  967, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "gbd", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "gbs",  968, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "gbs", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "isub",  994, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Isub", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "igidl",  996, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Igidl", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "igisl",  1005, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Igisl", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "igs",  1006, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Igs", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "igd",  1007, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Igd", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "igb",  1008, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Igb", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "igcs",  1009, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Igcs", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "igcd",  1010, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Igcd", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "vbs",  958, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Vbs", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "vgs",  959, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Vgs", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "vds",  960, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Vds", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "cgg",  975, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cggb", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "cgs",  977, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cgsb", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "cgd",  976, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cgdb", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "cbg",  978, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cbgb", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "cbd",  992, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cbdb", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "cbs",  993, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cbsb", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "cdg",  983, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cdgb", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "cdd",  984, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cddb", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "cds",  985, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cdsb", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "csg",  997, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Csgb", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "csd",  998, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Csdb", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "css",  999, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cssb", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "cgb",  1000, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cgbb", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "cdb",  1001, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cdbb", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "csb",  1002, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Csbb", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "cbb",  1003, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cbbb", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "capbd",  979, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Capbd", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "capbs",  981, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Capbs", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "qg",  971, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Qgate", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "qb",  969, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Qbulk", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "qd",  973, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Qdrain", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "qs",  1004, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Qsource", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "qinv",  995, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Qinversion", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "qdef",  1011, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Qdef", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "gcrg",  1013, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gcrg", true );
    modelInfos[MODEL_TYPE::BSIM4].instanceParams.emplace_back( "gtau",  1014, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gtau", true );
}