/*
 * Copyright 2000-2014 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.ide;

import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.BusyObject;
import org.jetbrains.annotations.NotNull;

public abstract class UiActivityMonitor {
  @NotNull
  public abstract BusyObject getBusy(@NotNull Project project, @NotNull UiActivity ... toWatch);

  @NotNull
  public abstract BusyObject getBusy(@NotNull UiActivity ... toWatch);

  public abstract void addActivity(@NotNull Project project, @NotNull UiActivity activity);

  public abstract void addActivity(@NotNull Project project, @NotNull UiActivity activity, @NotNull ModalityState effectiveModalityState);

  public abstract void addActivity(@NotNull UiActivity activity);

  public abstract void addActivity(@NotNull UiActivity activity, @NotNull ModalityState effectiveModalityState);

  public abstract void removeActivity(@NotNull Project project, @NotNull UiActivity activity);

  public abstract void removeActivity(@NotNull UiActivity activity);

  public abstract void clear();

  public abstract void setActive(boolean active);

  public static UiActivityMonitor getInstance() {
    return ServiceManager.getService(UiActivityMonitor.class);
  }

}
