#!/usr/bin/env python

"""
Common scheduling functionality.

Copyright (C) 2016 Paul Boddie <paul@boddie.org.uk>

This program is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free Software
Foundation; either version 3 of the License, or (at your option) any later
version.

This program is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
details.

You should have received a copy of the GNU General Public License along with
this program.  If not, see <http://www.gnu.org/licenses/>.
"""

def standard_responses(handler, response):

    """
    Using 'handler' to translate descriptions, return a tuple containing the
    'response' and a suitable description.
    """

    _ = handler.get_translator()

    if response == "ACCEPTED":
        return response, _("The recipient has scheduled the requested period.")
    elif response == "COUNTER":
        return response, _("The recipient has suggested a different period.")
    elif response == "DELEGATED":
        return response, _("The recipient has delegated the requested period.")
    else:
        return response, _("The recipient is unavailable in the requested period.")

def get_scheduling_conflicts(handler, freebusy, users, attendee=False):

    """
    Use the 'handler' to obtain scheduling conflicts within the given 'freebusy'
    collection involving the given 'users', with the organiser of each period
    being tested against the users unless 'attendee' is set to a true value
    (thus testing the attendee of each period against the users instead).

    Return a dictionary mapping users to the number of conflicts (or concurrent
    scheduling instances) each user experiences for the current object of the
    'handler'.
    """

    conflicts = {}

    for user in users:
        conflicts[user] = 0 

    overlapping = freebusy.get_overlapping(handler.get_periods(handler.obj))

    # Where scheduling cannot occur, find the busy potential users.

    if overlapping:
        for p in overlapping:
            involved = attendee and p.attendee or p.organiser
            if conflicts.has_key(involved):
                conflicts[involved] += 1

    return conflicts

# vim: tabstop=4 expandtab shiftwidth=4
