---
title: Lateef - Design
fontversion: 2.000
---

Lateef provides a &#x201c;simplified&#x201d; rendering of Arabic script, using basic connecting glyphs but not including a wide variety of additional ligatures or contextual alternates (only the required lam-alef ligatures). This simplified style is often preferred for clarity, especially in non-Arabic languages.

Seven weights for this typeface family are included:

- Lateef ExtraLight
- Lateef Light
- Lateef Regular
- Lateef Medium
- Lateef SemiBold
- Lateef Bold
- Lateef ExtraBold


## Type Samples

Type samples showing some of the inventory of glyphs can be found here: 
[Lateef Type Sample](sample.md).

Examples of some text is shown below. 

![Lateef Sample - Seven weights](assets/images/weights.png){.fullsize}
<!-- PRODUCT SITE IMAGE SRC https://software.sil.org/lateef/wp-content/uploads/sites/30/2022/06/weights.png -->
<figcaption>Lateef Sample - Seven weights</figcaption>


![Lateef Sample - Genesis 11](assets/images/LateefArabicGen11_LO.png){.fullsize}
<!-- PRODUCT SITE IMAGE SRC https://software.sil.org/lateef/wp-content/uploads/sites/30/2022/06/LateefArabicGen11_LO.png -->
<figcaption>Lateef Sample - Genesis 11</figcaption>

## Character Set

For a complete list of characters included in Lateef, see [Character Set Support](charset.md).

## Rendering the Allah ligature

In certain types of literature, the name *Allah* and words related to this name are given unique rendering. For a list of the rendering rules, see [Rendering the Allah ligature](allah.md).

## Font Features

Alternate glyphs that are available through features are demonstrated in the [Features](features.md) document. 
