/*
 * Copyright (C) 2019 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef TNT_FILAMENT_DRIVER_VULKANDRIVERFACTORY_H
#define TNT_FILAMENT_DRIVER_VULKANDRIVERFACTORY_H

#include <stdint.h>

namespace filament {

namespace backend {
class VulkanPlatform;
class Driver;

class VulkanDriverFactory {
public:
    static backend::Driver* create(backend::VulkanPlatform* platform,
            const char* const* ppEnabledExtensions, uint32_t enabledExtensionCount) noexcept;
};

} // namespace backend
} // namespace filament

#endif //TNT_FILAMENT_DRIVER_VULKANDRIVERFACTORY_H
