
module deimos.openssl.comp;

import deimos.openssl._d_util;

import deimos.openssl.bio; // Needed for BIO_METHOD.

public import deimos.openssl.crypto;

extern (C):
nothrow:

alias comp_ctx_st COMP_CTX;

struct comp_method_st {
	int type;		/* NID for compression library */
	const(char)* name;	/* A text string to identify the library */
	ExternC!(int function(COMP_CTX* ctx)) init_;
	ExternC!(void function(COMP_CTX* ctx)) finish;
	ExternC!(int function(COMP_CTX* ctx,
			ubyte* out_, uint olen,
			ubyte* in_, uint ilen)) compress;
	ExternC!(int function(COMP_CTX* ctx,
		      ubyte* out_, uint olen,
		      ubyte* in_, uint ilen)) expand;
	/* The following two do NOTHING, but are kept for backward compatibility */
	ExternC!(c_long function()) ctrl;
	ExternC!(c_long function()) callback_ctrl;
	}
alias comp_method_st COMP_METHOD;

struct comp_ctx_st
	{
	COMP_METHOD* meth;
	c_ulong compress_in;
	c_ulong compress_out;
	c_ulong expand_in;
	c_ulong expand_out;

	CRYPTO_EX_DATA	ex_data;
	};


COMP_CTX* COMP_CTX_new(COMP_METHOD* meth);
void COMP_CTX_free(COMP_CTX* ctx);
int COMP_compress_block(COMP_CTX* ctx, ubyte* out_, int olen,
	ubyte* in_, int ilen);
int COMP_expand_block(COMP_CTX* ctx, ubyte* out_, int olen,
	ubyte* in_, int ilen);
COMP_METHOD* COMP_rle();
COMP_METHOD* COMP_zlib();
void COMP_zlib_cleanup();

// #ifdef ZLIB
BIO_METHOD* BIO_f_zlib();
// #endif

/* BEGIN ERROR CODES */
/* The following lines are auto generated by the script mkerr.pl. Any changes
 * made after this point may be overwritten when the script is next run.
 */
void ERR_load_COMP_strings();

/* Error codes for the COMP functions. */

/* Function codes. */
enum COMP_F_BIO_ZLIB_FLUSH = 99;
enum COMP_F_BIO_ZLIB_NEW = 100;
enum COMP_F_BIO_ZLIB_READ = 101;
enum COMP_F_BIO_ZLIB_WRITE = 102;

/* Reason codes. */
enum COMP_R_ZLIB_DEFLATE_ERROR = 99;
enum COMP_R_ZLIB_INFLATE_ERROR = 100;
enum COMP_R_ZLIB_NOT_SUPPORTED = 101;
