/*
 * This file is part of din.
 *
 * din is copyright (c) 2006 - 2012 S Jagannathan <jag@dinisnoise.org>
 * For more information, please visit http://dinisnoise.org
 *
 * din is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * din is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with din.  If not, see <http://www.gnu.org/licenses/>.
 *
*/
#ifndef __crvpt
#define __crvpt

struct crvpt { // curve point

  float x, y;
  float t; // bezier param

  // used by solver (see solver.h/solver.cc)
  float m; // slope of seg joining next point
  int inf; // is slope infinity?

  crvpt () {
    x = y = t = m = 0;
    inf = 0;
  }

  crvpt (float xx, float yy, float tt) {
    x = xx; y = yy; t = tt;
    m = 0; inf = 0;
  }

};

#endif
