/*
 * This file is part of din.
 *
 * din is copyright (c) 2006 - 2012 S Jagannathan <jag@dinisnoise.org>
 * For more information, please visit http://dinisnoise.org
 *
 * din is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * din is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with din.  If not, see <http://www.gnu.org/licenses/>.
 *
*/
#include <algorithm>
#include <fstream>
#include <iostream>
#include "scalelist.h"
#include "console.h"
#include "tokenizer.h"
#include "command.h"
using namespace std;

extern console cons;
extern cmdlist cmdlst;

#define result cmdlst.result
#define buf cmdlst.buf

scalelist::scalelist () {
  load ();
}

scalelist::~scalelist () {
  save ();
}

int scalelist::add (tokenizer& tz) { // used by add-scale command, see command.cc
  string nam; tz >> nam;
  if (nam != "") {
    scale r;
    r.name = nam;
    string notes;
    while (1) {
      string s; tz >> s;
      if (s == "") break; else {
        notes = notes + s + " ";
        ++r.num_notes;
      }
    }
    if (r.num_notes > 1) {
      r.notes = notes;
      scales.push_back (r);
      result = nam + ": added";
      return 1;
    } else {
      result = "need at least 2 notes.";
      return 0;
    }
  }

  result = "bad scale name";
  return 0;

}

void scalelist::ls () { // used by ls-scale, see command.cc
  result = "";
  for (int i = 0, j = scales.size(); i < j; ++i) {
    scale& r = scales[i];
    result = result + r.name + eol;
  }
}

int scalelist::remove (const string& nam) { // used by remove-scale, see command.cc
  scale r; r.name = nam;
  vector<scale>::iterator i = find (scales.begin(), scales.end(), r);
  if (i != scales.end()) {
    scales.erase (i);
    result = nam + ": removed";
    return 1;
  }
  result = nam + ": not found";
  return 0;
}

void scalelist::load () {
  extern string dotdin;
  ifstream file ((dotdin + "scalelist").c_str(), ios::in);
  if (file) {
    int j;
    string ignore; file >> ignore >> j;
    for (int i = 0; i < j; ++i) {
      scale r;
      string nam; file >> nam; r.name = nam;
      file >> r.num_notes;
      for (int k = 0; k < r.num_notes; ++k) {
        string s; file >> s;
        r.notes = r.notes + s + ' ';
      }
      scales.push_back (r);
    }
  } else cout << "bad scalelist file" << endl;
}

void scalelist::save () {
  extern string dotdin;
  ofstream file ((dotdin + "scalelist").c_str(), ios::out);
  if (file) {
    int j = scales.size();
    file << "num_scales " << j << eol;
    for (int i = 0; i < j; ++i) {
      scale& r = scales[i];
      file << r.name << " " << r.num_notes << ' ' << r.notes << eol;
    }
  }
}

int scalelist::get (const string& n, scale& r) {
  r.name = n;
  vector<scale>::iterator i = find (scales.begin(), scales.end(), r);
  if (i != scales.end()) {
    r = *i;
    return 1;
  }
  return 0;
}
