#ifndef PRINTINFO_H
#define PRINTINFO_H

#include <stdio.h>
#include <inttypes.h>

#include "process_int.h"

#define DATE_FORMAT "%5.4d-%2.2d-%2.2d"
#define TIME_FORMAT "%2.2d:%2.2d:%2.2d"

std::string datetimeToString(int64_t date, int time);
std::string dateToString(int64_t date);
std::string timeToString(int time);

const char *comptypeToName(int comptype);

void printFiletype(CdoStreamID p_streamID, int vlistID);
void printGridInfo(int vlistID);
void printZaxisInfo(int vlistID);
void printSubtypeInfo(int vlistID);
void printTimesteps(CdoStreamID streamID, int taxisID, int verbose);

#endif
/*
 * Local Variables:
 * c-file-style: "Java"
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * show-trailing-whitespace: t
 * require-trailing-newline: t
 * End:
 */
